/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.InsertResultsType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionResultsType;
import net.opengis.wfs.TransactionType;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.response.WFS10Response;
import org.opengis.filter.identity.FeatureId;
import org.vfny.geoserver.global.Data;

public class TransactionResponse
extends WFS10Response {
    private boolean verbose = false;
    private String indent = " ";
    private String offset = "";
    WFS wfs;
    Data catalog;

    public TransactionResponse(WFS wfs, Data catalog) {
        super(TransactionResponseType.class);
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResponseType response = (TransactionResponseType)value;
        this.v_1_0(response, output, operation);
    }

    public void v_1_0(TransactionResponseType response, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResultsType result = response.getTransactionResults();
        Writer writer = new OutputStreamWriter(output, this.wfs.getCharSet());
        writer = new BufferedWriter(writer);
        String encoding = this.wfs.getCharSet().name();
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        writer.write(xmlHeader);
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("<wfs:WFS_TransactionResponse");
        writer.write(this.indent + "version=\"1.0.0\"");
        writer.write(this.indent + "xmlns:wfs=\"http://www.opengis.net/wfs\"");
        writer.write(this.indent + "xmlns:ogc=\"http://www.opengis.net/ogc\"");
        writer.write(this.indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.write(this.indent);
        writer.write("xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        TransactionType req = (TransactionType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        String baseUrl = ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.0.0/WFS-transaction.xsd");
        writer.write(baseUrl);
        writer.write("\">");
        InsertResultsType insertResults = response.getInsertResults();
        String lastHandle = null;
        boolean first = true;
        if (insertResults != null) {
            for (InsertedFeatureType insertedFeature : insertResults.getFeature()) {
                String handle = insertedFeature.getHandle();
                if (first || lastHandle == null && handle != null || lastHandle != null && handle != null && handle.equals(lastHandle)) {
                    if (!first) {
                        writer.write("</wfs:InsertResult>");
                    }
                    writer.write("<wfs:InsertResult");
                    if (insertedFeature.getHandle() != null) {
                        writer.write(" handle=\"" + insertedFeature.getHandle() + "\"");
                    }
                    writer.write(">");
                }
                for (FeatureId featureId : insertedFeature.getFeatureId()) {
                    writer.write("<ogc:FeatureId fid=\"" + featureId.toString() + "\"/>");
                }
                first = false;
                lastHandle = handle;
            }
            writer.write("</wfs:InsertResult>");
        }
        writer.write(this.indent + "<wfs:TransactionResult");
        if (result.getHandle() != null) {
            writer.write(" handle=\"" + result.getHandle() + "\"");
        }
        writer.write(">");
        writer.write(this.indent + this.offset + "<wfs:Status>");
        writer.write(this.indent + this.offset + this.offset);
        if (!result.getAction().isEmpty()) {
            writer.write("<wfs:FAILED/>");
        } else {
            writer.write("<wfs:SUCCESS/>");
        }
        writer.write(this.indent + this.offset + "</wfs:Status>");
        if (!result.getAction().isEmpty()) {
            ActionType action = (ActionType)result.getAction().get(0);
            if (action.getLocator() != null) {
                writer.write(this.indent + this.offset + "<wfs:Locator>");
                writer.write(action.getLocator() + "</wfs:Locator>");
            }
            if (action.getMessage() != null) {
                writer.write(this.indent + this.offset + "<wfs:Message>");
                ResponseUtils.writeEscapedString((Writer)writer, (String)action.getMessage());
                writer.write("</wfs:Message>");
            }
        }
        writer.write(this.indent + "</wfs:TransactionResult>");
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("</wfs:WFS_TransactionResponse>");
        writer.flush();
    }
}

