/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.LegacyServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.GMLInfoImpl;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSInfoImpl;

public class WFSLoader
extends LegacyServiceLoader {
    public String getServiceId() {
        return "wfs";
    }

    public Class getServiceClass() {
        return WFSInfo.class;
    }

    public ServiceInfo load(LegacyServicesReader reader, GeoServer geoServer) throws Exception {
        WFSInfoImpl wfs = new WFSInfoImpl();
        wfs.setId(this.getServiceId());
        Map properties = reader.wfs();
        this.readCommon(wfs, properties, geoServer);
        wfs.setServiceLevel(WFSInfo.ServiceLevel.get((Integer)properties.get("serviceLevel")));
        GMLInfoImpl gml = new GMLInfoImpl();
        gml.setFeatureBounding((Boolean)properties.get("featureBounding"));
        Boolean srsXmlStyle = (Boolean)properties.get("srsXmlStyle");
        if (srsXmlStyle.booleanValue()) {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.XML);
        } else {
            gml.setSrsNameStyle(GMLInfo.SrsNameStyle.NORMAL);
        }
        wfs.getGML().put(WFSInfo.Version.V_10, gml);
        gml = new GMLInfoImpl();
        gml.setFeatureBounding(true);
        gml.setSrsNameStyle(GMLInfo.SrsNameStyle.URN);
        wfs.getGML().put(WFSInfo.Version.V_11, gml);
        return wfs;
    }
}

