/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import java.io.Serializable;
import org.kaffe.java.util.AbstractSet;
import org.kaffe.java.util.Collection;
import org.kaffe.java.util.Comparator;
import org.kaffe.java.util.Iterator;
import org.kaffe.java.util.Map;
import org.kaffe.java.util.SortedMap;
import org.kaffe.java.util.SortedSet;
import org.kaffe.java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private SortedMap map;

    public TreeSet() {
        this.map = new TreeMap();
    }

    public TreeSet(Collection collection) {
        this.map = new TreeMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.map.put(iterator.next(), null);
        }
    }

    public TreeSet(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    TreeSet(SortedMap sortedMap) {
        this.map = sortedMap;
    }

    public TreeSet(SortedSet sortedSet) {
        this.map = new TreeMap(sortedSet.comparator());
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            this.map.put(iterator.next(), null);
        }
    }

    public boolean add(Object object) {
        boolean bl = !this.map.containsKey(object);
        this.map.put(object, null);
        return bl;
    }

    public boolean addAll(Collection collection) {
        int n = this.map.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.map.put(iterator.next(), null);
        }
        return this.map.size() != n;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet treeSet;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        treeSet.map = this.map instanceof TreeMap ? (SortedMap)((TreeMap)this.map).clone() : new TreeMap(this.map);
        return treeSet;
    }

    public Comparator comparator() {
        return this.map.comparator();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public Object first() {
        return this.map.firstKey();
    }

    public SortedSet headSet(Object object) {
        return new TreeSet(this.map.headMap(object));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return new Iterator(){
            private final Iterator i;
            {
                this.i = TreeSet.this.map.entrySet().iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                Map.Entry entry = (Map.Entry)this.i.next();
                return entry.getKey();
            }

            public void remove() {
                this.i.remove();
            }
        };
    }

    public Object last() {
        return this.map.lastKey();
    }

    public boolean remove(Object object) {
        if (this.map.containsKey(object)) {
            this.map.remove(object);
            return true;
        }
        return false;
    }

    public int size() {
        return this.map.size();
    }

    public SortedSet subSet(Object object, Object object2) {
        return new TreeSet(this.map.subMap(object, object2));
    }

    public SortedSet tailSet(Object object) {
        return new TreeSet(this.map.tailMap(object));
    }
}

