/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import java.util.NoSuchElementException;
import org.kaffe.java.util.AbstractList;
import org.kaffe.java.util.ConcurrentModificationException;
import org.kaffe.java.util.ListIterator;

class AbstractListIterator
implements ListIterator {
    protected final AbstractList list;
    protected int lastIndex = -1;
    protected int modCount;
    protected int index;

    AbstractListIterator(AbstractList abstractList, int n) {
        if (n < 0 || n > abstractList.size()) {
            throw new IllegalArgumentException();
        }
        this.list = abstractList;
        this.index = n;
        this.modCount = abstractList.modCount;
    }

    public void add(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        this.list.add(this.index, object);
        ++this.modCount;
        ++this.index;
    }

    public boolean hasNext() {
        return this.index < this.list.size();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public Object next() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index >= this.list.size()) {
            throw new NoSuchElementException();
        }
        Object object = this.list.get(this.index);
        this.lastIndex = this.index++;
        return object;
    }

    public int nextIndex() {
        return this.index;
    }

    public Object previous() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index <= 0) {
            throw new NoSuchElementException();
        }
        Object object = this.list.get(this.index - 1);
        this.lastIndex = --this.index;
        return object;
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public void remove() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.remove(this.lastIndex);
        ++this.modCount;
        if (this.lastIndex < this.index) {
            --this.index;
        }
        this.lastIndex = -1;
    }

    public void set(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.set(this.lastIndex, object);
    }
}

