/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;
    boolean inProgress;
    public Vector edits;

    public UndoManager() {
        this.edits = ((CompoundEdit)this).edits;
        this.edits.ensureCapacity(this.limit);
        this.inProgress = super.isInProgress();
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, ((CompoundEdit)this).edits.size() - 1);
        boolean bl = super.addEdit(undoableEdit);
        if (this.inProgress) {
            bl = true;
        }
        this.indexOfNextAdd = ((CompoundEdit)this).edits.size();
        this.trimForLimit();
        return bl;
    }

    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            return undoableEdit != null && undoableEdit.canRedo();
        }
        return super.canRedo();
    }

    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            return undoableEdit != null && undoableEdit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == ((CompoundEdit)this).edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    public synchronized void discardAllEdits() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
            undoableEdit.die();
        }
        ((CompoundEdit)this).edits = new Vector(this.limit);
        this.indexOfNextAdd = 0;
    }

    protected UndoableEdit editToBeRedone() {
        int n = ((CompoundEdit)this).edits.size();
        int n2 = this.indexOfNextAdd;
        while (n2 < n) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = ((CompoundEdit)this).edits.elementAt(n2++)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected UndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd;
        while (n > 0) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = ((CompoundEdit)this).edits.elementAt(--n)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, ((CompoundEdit)this).edits.size() - 1);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return "Redo";
        }
        return super.getRedoPresentationName();
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return "Undo";
        }
        return super.getUndoPresentationName();
    }

    public synchronized void redo() throws CannotRedoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(undoableEdit);
        } else {
            super.redo();
        }
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            undoableEdit2.redo();
            bl = undoableEdit2 == undoableEdit;
        }
    }

    public Object returnConfiguration() {
        return ((CompoundEdit)this).edits.get(this.indexOfNextAdd - 1);
    }

    public synchronized void setLimit(int n) {
        this.limit = n;
        this.trimForLimit();
    }

    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }

    protected void trimEdits(int n, int n2) {
        if (n <= n2) {
            for (int i = n2; n <= i; --i) {
                UndoableEdit undoableEdit = ((CompoundEdit)this).edits.elementAt(i);
                undoableEdit.die();
                this.edits.removeElementAt(i);
            }
            if (this.indexOfNextAdd > n2) {
                this.indexOfNextAdd -= n2 - n + 1;
            } else if (this.indexOfNextAdd >= n) {
                this.indexOfNextAdd = n;
            }
        }
    }

    protected void trimForLimit() {
        int n;
        if (this.limit > 0 && (n = ((CompoundEdit)this).edits.size()) > this.limit) {
            int n2 = this.limit / 2;
            int n3 = this.indexOfNextAdd - 1 + n2;
            int n4 = this.indexOfNextAdd - 1 - n2;
            if (n3 - n4 + 1 > this.limit) {
                ++n4;
            }
            if (n4 < 0) {
                n3 -= n4;
                n4 = 0;
            }
            if (n3 >= n) {
                int n5 = n - n3 - 1;
                n3 += n5;
                n4 += n5;
            }
            this.trimEdits(n3 + 1, n - 1);
            this.trimEdits(0, n4 - 1);
        }
    }

    public synchronized void undo() throws CannotUndoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(undoableEdit);
        } else {
            super.undo();
        }
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == ((CompoundEdit)this).edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = ((CompoundEdit)this).edits.elementAt(--this.indexOfNextAdd);
            undoableEdit2.undo();
            bl = undoableEdit2 == undoableEdit;
        }
    }
}

