/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class Polygon
extends Element
implements MouseMotionListener {
    Point[] points;
    Line[] border;

    public Polygon() {
        this.initPolygon();
        this.points = new Point[0];
        this.border = new Line[0];
    }

    public Polygon(String string, int n, Vector vector, int n2) {
        super(string, n, n2);
        int n3;
        this.initPolygon();
        this.points = new Point[vector.size()];
        for (n3 = 0; n3 < vector.size(); ++n3) {
            this.points[n3] = (Point)vector.get(n3);
        }
        this.border = new Line[vector.size() - 1];
        for (n3 = 0; n3 < this.border.length; ++n3) {
            this.border[n3] = new Line(string + n + "l", n3, (Point)vector.get(n3), (Point)vector.get(n3 + 1), 0);
        }
    }

    public Polygon(Vector vector, int n, int n2) {
        super("P" + n, n, n2);
        int n3;
        this.initPolygon();
        this.points = new Point[vector.size()];
        for (n3 = 0; n3 < vector.size(); ++n3) {
            this.points[n3] = (Point)vector.get(n3);
        }
        this.border = new Line[vector.size()];
        for (n3 = 0; n3 < vector.size() - 1; ++n3) {
            this.border[n3] = new Line("", 0, (Point)vector.get(n3), (Point)vector.get(n3 + 1), 0);
        }
        this.border[vector.size() - 1] = new Line("", 0, (Point)vector.get(0), (Point)vector.lastElement(), 0);
    }

    public Vector data() {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < this.points.length; ++i) {
            vector.addElement(this.points[i]);
        }
        return vector;
    }

    public String description() {
        String string = this.generateDesc(Geonext.language.getString("polygon_description"));
        for (int i = 0; i < this.points.length - 1; ++i) {
            string = string + this.generateDesc("<b>{BorderElement#" + i + "}</b> = [<b>{PointElement#" + i + "}{PointElement#" + (i + 1) + "}</b>], ");
        }
        string = string.substring(0, string.length() - 2) + ".";
        return string;
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            if (!this.isDraft()) {
                graphics2D.setColor(this.getFill());
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.fillPolygon(this.getX(), this.getY(), this.getLength() - 1);
            if (this.isNameDrawed()) {
                if (this.isDraft()) {
                    if (this.isTextName() && this.getNameText() != null) {
                        jBoardPane.drawName(graphics2D, this.getNameText(), (int)jBoardPane.user2screen(this.getTextAnchor()).getWidth(), (int)jBoardPane.user2screen(this.getTextAnchor()).getHeight(), this.getDraftColor(), 0, 12);
                    } else {
                        jBoardPane.drawName(graphics2D, this.getName(), (int)jBoardPane.user2screen(this.getTextAnchor()).getWidth(), (int)jBoardPane.user2screen(this.getTextAnchor()).getHeight(), this.getDraftColor(), 0, 12);
                    }
                } else if (this.isTextName() && this.getNameText() != null) {
                    jBoardPane.drawName(graphics2D, this.getNameText(), (int)jBoardPane.user2screen(this.getTextAnchor()).getWidth(), (int)jBoardPane.user2screen(this.getTextAnchor()).getHeight(), this.getLabel(), 0, 12);
                } else {
                    jBoardPane.drawName(graphics2D, this.getName(), (int)jBoardPane.user2screen(this.getTextAnchor()).getWidth(), (int)jBoardPane.user2screen(this.getTextAnchor()).getHeight(), this.getLabel(), 0, 12);
                }
            }
        }
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i].draw(graphics2D, jBoardPane);
        }
    }

    public void drawTrace(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.isTrace() && this.exists() && this.isVisible()) {
            if (!this.isDraft()) {
                graphics2D.setColor(this.getFill());
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.fillPolygon(this.getX(), this.getY(), this.getLength() - 1);
        }
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i].drawTrace(graphics2D, jBoardPane);
        }
    }

    public boolean exists() {
        int n = 0;
        while (n < this.points.length) {
            if (this.points[n++].exists()) continue;
            return false;
        }
        return true;
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterPolygon++;
        String string2 = Geonext.language.getString("polygon_auto_name");
        while (!bl) {
            while (n > -1) {
                string = "" + (char)(97 + n % 26) + string;
                n = (n - n % 26) / 26 - 1;
            }
            if (elementSet.searchName(string2 + "_" + string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterPolygon;
        }
        this.setName(string2 + "_" + string);
    }

    public String getElementName() {
        if (this.border.length > 0 && this.border.length < 13) {
            return Geonext.language.getString("polygon_element_name_" + this.border.length);
        }
        return Geonext.language.getString("polygon_element_name");
    }

    public String getPolygon() {
        return this.getElementName();
    }

    public int getLength() {
        return this.points.length;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public Line getBorderElement(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.border[n];
    }

    public Point getPointElement(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.points[n];
    }

    public String getPointelements() {
        String string = "";
        for (int i = 0; i < this.points.length - 1; ++i) {
            string = string + this.points[i].getName();
        }
        return string;
    }

    public Coordinates getTextAnchor() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d = d3 = this.points[0].getUserX();
        d2 = d4 = this.points[0].getUserY();
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].getUserX() < d) {
                d = this.points[i].getUserX();
            }
            if (this.points[i].getUserX() > d3) {
                d3 = this.points[i].getUserX();
            }
            if (this.points[i].getUserY() > d2) {
                d2 = this.points[i].getUserY();
            }
            if (!(this.points[i].getUserY() < d4)) continue;
            d4 = this.points[i].getUserY();
        }
        return new Coordinates((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public Coordinates getTextAnchorScreen() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d = d3 = this.points[0].getScreenX();
        d2 = d4 = this.points[0].getScreenY();
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].getScreenX() < d) {
                d = this.points[i].getScreenX();
            }
            if (this.points[i].getScreenX() > d3) {
                d3 = this.points[i].getScreenX();
            }
            if (this.points[i].getScreenY() > d2) {
                d2 = this.points[i].getScreenY();
            }
            if (!(this.points[i].getScreenY() < d4)) continue;
            d4 = this.points[i].getScreenY();
        }
        return new Coordinates((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public int[] getX() {
        int[] nArray = new int[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            nArray[i] = (int)Math.round(this.points[i].getScreenX());
        }
        return nArray;
    }

    public int[] getY() {
        int[] nArray = new int[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            nArray[i] = (int)Math.round(this.points[i].getScreenY());
        }
        return nArray;
    }

    public void initPolygon() {
        this.stroke = new Color(0, 0, 255, 0);
        this.fill = new Color(0, 255, 0, 50);
        this.lighting = Color.pink;
        this.label = new Color(0, 0, 0, 0);
        this.typeString = "polygon";
        this.setElementName(Geonext.language.getString("polygon_element_name"));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            boolean bl = true;
            Vector<Element> vector = new Vector<Element>();
            while (!this.tag(string3, "vertex")[1].equals("")) {
                vector.addElement(jBoardPane.element.searchLoadID(this.tag(string3, "vertex")[1]));
                string3 = this.tag(string3, "vertex")[0];
            }
            jBoardPane.createPolygon(vector, string2, false);
            Polygon polygon = (Polygon)jBoardPane.element.polygon.lastElement();
            String string4 = "";
            string = polygon.parseProperties(string);
            for (int i = 0; i < polygon.border.length; ++i) {
                Line line = polygon.border[i];
                string4 = this.tag(string, "border")[1];
                string = this.tag(string, "border")[0];
                if (string4.equals("")) continue;
                line.setName(this.tag(string4, "name")[1]);
                string4 = this.tag(string4, "name")[0];
                string4 = line.parseProperties(string4);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Element searchLoadID(String string) {
        if (this.getLoadID().equals(string)) {
            return this;
        }
        for (int i = 0; i < this.border.length; ++i) {
            if (!this.border[i].getLoadID().equals(string)) continue;
            return this.border[i];
        }
        return null;
    }

    public Element searchName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        for (int i = 0; i < this.border.length; ++i) {
            if (!this.border[i].getName().equals(string)) continue;
            return this.border[i];
        }
        return null;
    }

    public void setDash(int n) {
        super.setDash(n);
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i].setDash(n);
        }
    }

    public void setPoints(Point[] pointArray) {
        this.points = pointArray;
    }

    public void setStroke(Color color) {
        super.setStroke(color);
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i].setStroke(color);
        }
    }

    public void setStrokeWidth(int n) {
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i].setStrokeWidth(n);
        }
    }

    public String svg() {
        String string = new String();
        if (this.exists() && this.isVisible()) {
            if (!this.isDraft()) {
                string = string + "<polygon style=\"stroke-width:1; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getFill()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getFill().getAlpha() / 255.0 + "\" points=\"";
                for (int i = 0; i < this.points.length; ++i) {
                    string = string + this.getX()[i] + "," + this.getY()[i] + " ";
                }
                string = string + "\"/>\n";
                string = string + "<text x=\"" + (int)this.getTextAnchorScreen().getWidth() + "\" y=\"" + (int)this.getTextAnchorScreen().getHeight() + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
                string = string + this.rgb2svgrgb(this.getLabel());
                string = string + "; fill-opacity:" + (double)this.getLabel().getAlpha() / 255.0;
                string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
                return string;
            }
            string = string + "<polygon style=\"stroke-width:1; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" +points=\"";
            for (int i = 0; i < this.points.length; ++i) {
                string = string + this.getX()[i] + "," + this.getY()[i] + " ";
            }
            string = string + "<text x=\"" + (int)this.getTextAnchorScreen().getWidth() + "\" y=\"" + (int)this.getTextAnchorScreen().getHeight() + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
            string = string + this.rgb2svgrgb(this.getLabel());
            string = string + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0;
            string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
            return string;
        }
        return string;
    }

    public String toString() {
        return super.toString();
    }

    public Vector vectorName() {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.getName());
        for (int i = 0; i < this.border.length; ++i) {
            vector.addElement(this.border[i].vectorName());
        }
        return vector;
    }

    public String writeData(String string) {
        String string2 = "";
        for (int i = 0; i < this.points.length; ++i) {
            string2 = string2 + string + "<vertex>" + this.points[i].getId() + "</vertex>\n ";
        }
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        for (int i = 0; i < this.border.length; ++i) {
            string2 = string2 + string + "<border>\n";
            string2 = string2 + string + "\t<name>" + this.border[i].getName() + "</name>\n";
            string2 = string2 + string + "\t<id>" + this.border[i].getId() + "</id>\n";
            string2 = string2 + this.border[i].writeProperties(string + "\t");
            string2 = string2 + string + "</border>\n";
        }
        return string2;
    }

    public String shortInfo() {
        String string = Geonext.language.getString("polygon_short") + " ";
        for (int i = 0; i < this.points.length - 2; ++i) {
            string = string + "{PointElement#" + i + "},";
        }
        string = string + "{PointElement#" + (this.points.length - 2) + "}";
        return this.generateShort(string);
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
    }

    public void calculateChanged(boolean bl) {
        this.setChanged(false);
        if (bl) {
            this.setChanged(true);
            for (int i = 0; i < this.border.length - 1; ++i) {
                this.border[i].setChanged(true);
            }
        } else {
            for (int i = 0; i < this.points.length - 1; ++i) {
                if (this.points[i].isChanged() || this.points[i + 1].isChanged()) {
                    this.border[i].setChanged(true);
                    if (this.isChanged()) continue;
                    this.setChanged(true);
                    continue;
                }
                this.border[i].setChanged(false);
            }
        }
    }
}

