/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import geonext.JRadioButton;
import geonext.PrinterSetup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import util.Compression;

class JContentPrint
extends JContentPanel
implements ActionListener,
Printable,
CaretListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public JBoardPane board;
    public JComboBox yInput;
    public JLabel pName;
    public DocFlavor flavor;
    public PrintRequestAttributeSet pras;
    public PrintService[] services;
    public JTextField copies;
    public PrinterJob printerJob;
    public PageFormat pageFormat;
    public JRadioButton unitRadio;
    public JTextField unitTextX;
    public JTextField unitTextY;
    public JTextField corrTextX;
    public double unitX;
    public JTextField corrTextY;
    public double unitY;
    Runnable runnable;
    String storedX = "1";
    String storedY = "1";
    boolean updateerror = false;
    public JRadioButton scalRadio;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Reader;

    public JContentPrint() {
    }

    public JContentPrint(JBoardPane jBoardPane) {
        this.printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printerJob.defaultPage();
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        this.pName = new JLabel(this.printerJob.getPrintService().toString());
        JButton jButton = new JButton(Geonext.language.getString("jcontentprint_settings"));
        jButton.setActionCommand("change");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel.add(this.pName);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentprint_printer") + " "));
        jPanel2.add("Center", jPanel);
        this.unitRadio = new JRadioButton(Geonext.language.getString("jcontentsave_unit"));
        this.unitRadio.addActionListener(this);
        this.unitRadio.setActionCommand("unit");
        this.unitRadio.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel jLabel = new JLabel(Geonext.language.getString("jcontentprint_unit_cm_x-axis"));
        jLabel.setForeground(Color.black);
        this.unitTextX = new JTextField("1");
        this.unitTextX.addCaretListener(this);
        this.unitTextX.addFocusListener(this);
        this.unitTextX.setActionCommand("rescale");
        this.unitTextX.addActionListener(this);
        JLabel jLabel2 = new JLabel(Geonext.language.getString("jcontentprint_unit_cm_y-axis"));
        jLabel2.setForeground(Color.black);
        this.unitTextY = new JTextField("1");
        this.unitTextY.setEditable(false);
        this.rescale();
        PrinterSetup printerSetup = PrinterSetup.getPrinterSettings(jBoardPane.geonext.pVector, this.pName.getText());
        JLabel jLabel3 = new JLabel(Geonext.language.getString("jcontentprint_cm_x-axis"));
        jLabel3.setForeground(Color.black);
        this.corrTextX = new JTextField(printerSetup.getX() + "");
        this.corrTextX.setActionCommand("printerSetup");
        this.corrTextX.addActionListener(this);
        this.corrTextX.addCaretListener(this);
        JLabel jLabel4 = new JLabel(Geonext.language.getString("jcontentprint_cm_y-axis"));
        jLabel4.setForeground(Color.black);
        this.corrTextY = new JTextField(printerSetup.getY() + "");
        this.corrTextY.setActionCommand("printerSetup");
        this.corrTextY.addActionListener(this);
        this.corrTextY.addCaretListener(this);
        this.corrTextY.setMinimumSize(new Dimension(50, 20));
        this.scalRadio = new JRadioButton(Geonext.language.getString("jcontentprint_scaletopage"));
        this.scalRadio.setSelected(true);
        this.scalRadio.addActionListener(this);
        this.scalRadio.setActionCommand("unit");
        this.scalRadio.setBorder(new EmptyBorder(0, 0, 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.unitRadio);
        buttonGroup.add(this.scalRadio);
        JLabel jLabel5 = new JLabel(Geonext.language.getString("jcontentprint_calibration"));
        JButton jButton2 = new JButton(Geonext.language.getString("jcontentprint_print_test_page"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("calibration");
        JButton jButton3 = new JButton(Geonext.language.getString("jframedialog_reset"));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("reset_corr");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.add(this.scalRadio);
        jPanel3.add(this.unitRadio);
        jPanel3.add(this.unitTextX);
        jPanel3.add(this.unitTextY);
        jPanel3.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel3.add(jLabel5);
        jPanel3.add(jButton2);
        jPanel3.add(this.corrTextX);
        jPanel3.add(this.corrTextY);
        jPanel3.add(jLabel3);
        jPanel3.add(jLabel4);
        jPanel3.add(jButton3);
        Geonext.setComponentLayout(gridBagLayout, this.scalRadio, gridBagConstraints, 0, 0, 2, 1, 0, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, this.unitRadio, gridBagConstraints, 0, 1, 1, 1, 1, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, this.unitTextX, gridBagConstraints, 1, 1, 1, 1, 1, 0, 10, 2, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, this.unitTextY, gridBagConstraints, 1, 2, 1, 1, 0, 0, 10, 2, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jLabel, gridBagConstraints, 2, 1, 1, 1, 10, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jLabel2, gridBagConstraints, 2, 2, 1, 1, 0, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jLabel5, gridBagConstraints, 0, 3, 4, 1, 1, 1, 16, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jButton2, gridBagConstraints, 0, 4, 1, 2, 0, 0, 13, 1, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, this.corrTextX, gridBagConstraints, 1, 4, 1, 1, 0, 0, 10, 2, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, this.corrTextY, gridBagConstraints, 1, 5, 1, 1, 0, 0, 10, 2, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jLabel3, gridBagConstraints, 2, 4, 1, 1, 0, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jLabel4, gridBagConstraints, 2, 5, 1, 1, 0, 0, 17, 0, 0, 0);
        Geonext.setComponentLayout(gridBagLayout, jButton3, gridBagConstraints, 3, 5, 1, 1, 0, 0, 17, 0, 0, 0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel4.add("Center", jPanel3);
        this.add("North", jPanel2);
        this.add("Center", jPanel4);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.print();
            this.reset();
            this.board.getGeonextPrintDialog().dispose();
        } else if (string.equals("change")) {
            this.printerJob.printDialog();
            this.pageFormat = this.printerJob.defaultPage();
            this.pName.setText(this.printerJob.getPrintService().toString());
            PrinterSetup printerSetup = PrinterSetup.getPrinterSettings(this.board.geonext.pVector, this.pName.getText());
            System.out.println(printerSetup.getX() + "" + printerSetup.getY());
            this.corrTextX.removeCaretListener(this);
            this.corrTextY.removeCaretListener(this);
            this.corrTextX.setText("" + printerSetup.getX());
            this.corrTextY.setText("" + printerSetup.getY());
            this.corrTextX.addCaretListener(this);
            this.corrTextY.addCaretListener(this);
        } else if (!string.equals("apply")) {
            if (string.equals("cancel")) {
                this.board.getGeonextPrintDialog().dispose();
            } else if (string.equals("rescale")) {
                this.rescale();
            } else if (string.equals("printerSetup")) {
                this.printerSetup();
            } else if (string.equals("calibration")) {
                this.printCalibration();
            } else if (string.equals("reset_corr")) {
                this.corrTextX.setText("10");
                this.corrTextY.setText("10");
                this.printerSetup();
            }
        }
        this.board.repaint();
    }

    public void addCaretListenerX() {
        this.corrTextX.addCaretListener(this);
    }

    public void rescale() {
        this.unitRadio.setSelected(true);
        this.unitTextX.removeCaretListener(this);
        String string = this.unitTextX.getText();
        try {
            if (string.equals("")) {
                string = "1";
            }
            this.unitX = new Double(string);
            this.unitY = this.unitX * this.board.unit.getHeight() / this.board.unit.getWidth();
            this.unitTextY.setText(this.unitY + "");
            this.storedX = this.unitX + "";
            if (this.storedX.endsWith(".0")) {
                this.storedX = this.storedX.substring(0, this.storedX.length() - 2);
            }
            this.storedY = this.unitY + "";
            if (this.storedY.endsWith(".0")) {
                this.storedY = this.storedY.substring(0, this.storedY.length() - 2);
            }
        }
        catch (Exception exception) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JContentPrint.this.unitTextX.setText(JContentPrint.this.storedX);
                    JContentPrint.this.unitTextX.setText(JContentPrint.this.storedY);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        this.unitTextX.addCaretListener(this);
    }

    public void reset() {
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0) {
            this.board.getJep().setScreenShot(true);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.board.getJep().paint(graphics2D);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(-250, -250, 2000, 250);
            graphics2D.fillRect(-250, this.board.getHeight(), 2000, 2000);
            graphics2D.fillRect(-250, 0, 250, this.board.getHeight());
            graphics2D.fillRect(this.board.getWidth(), 0, 2000, this.board.getHeight());
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, this.board.getWidth(), this.board.getHeight());
            graphics2D.drawString("\u00a9 2002      http://geonext.de      " + this.board.getTitle(), 0, this.board.getHeight() + graphics2D.getFontMetrics().getHeight());
            this.board.getJep().setScreenShot(false);
            return 0;
        }
        return 1;
    }

    public void printerSetup() {
        this.board.geonext.pVector = new PrinterSetup(this.pName.getText(), this.corrTextX.getText(), this.corrTextY.getText()).addPrinterSettings(this.board.geonext.pVector);
    }

    public void print() {
        this.printSVG(this.board, this.scalRadio.isSelected(), new Double(this.corrTextX.getText()), new Double(this.corrTextY.getText()));
    }

    public void printSVG(JBoardPane jBoardPane, boolean bl, double d, double d2) {
        this.runnable = null;
        double d3 = 0.9244 * d;
        double d4 = 0.9289999999999999 * d2;
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.apache.batik.transcoder.print.PrintTranscoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName("org.apache.batik.transcoder.TranscodingHints$Key");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class<?> clazz3 = null;
            try {
                clazz3 = Class.forName("org.apache.batik.transcoder.TranscoderSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor2 = clazz3.getConstructor(new Class[0]);
            Object obj2 = constructor2.newInstance(new Object[0]);
            Method method = clazz3.getDeclaredMethod("addTranscodingHint", clazz2, class$java$lang$Object == null ? (class$java$lang$Object = JContentPrint.class$("java.lang.Object")) : class$java$lang$Object);
            Field field = clazz.getField("KEY_SHOW_PAGE_DIALOG");
            if (!bl) {
                field = clazz.getField("KEY_WIDTH");
                double d5 = 35.0;
                method.invoke(obj, field.get(obj), new Float(jBoardPane.svgX(jBoardPane.getSize().width) * (d5 *= d4 / d3 * 10.0 / d4) * this.unitX));
                field = clazz.getField("KEY_SCALE_TO_PAGE");
                method.invoke(obj, field.get(obj), Boolean.FALSE);
            } else {
                field = clazz.getField("KEY_SCALE_TO_PAGE");
                method.invoke(obj, field.get(obj), Boolean.TRUE);
            }
            Class<?> clazz4 = null;
            try {
                clazz4 = Class.forName("org.apache.batik.transcoder.TranscoderInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor3 = clazz4.getConstructor(class$java$io$Reader == null ? (class$java$io$Reader = JContentPrint.class$("java.io.Reader")) : class$java$io$Reader);
            Object var22_24 = null;
            if (!bl) {
                double d6 = 1.0;
                var22_24 = constructor3.newInstance(jBoardPane.jep.paintSVG(1.0, true, d6 *= d4 / d3));
            } else {
                var22_24 = constructor3.newInstance(jBoardPane.jep.paintSVG(1.0, true, 1.0));
            }
            Class<?> clazz5 = null;
            try {
                clazz5 = Class.forName("org.apache.batik.transcoder.TranscoderOutput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Method method2 = clazz.getDeclaredMethod("transcode", clazz4, clazz5);
            method2.invoke(obj, new Object[]{var22_24, null});
            Method method3 = clazz.getDeclaredMethod("print", new Class[0]);
            Paper paper = this.pageFormat.getPaper();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = (float)paper.getWidth();
            float f4 = (float)paper.getHeight();
            paper.setImageableArea(f, f2, f3, f4);
            this.pageFormat.setPaper(paper);
            this.pageFormat = this.printerJob.validatePage(this.pageFormat);
            System.out.println(this.printerJob.getPrintService().toString());
            this.printerJob.setPrintService(this.printerJob.getPrintService());
            this.printerJob.setPrintable((Printable)obj, this.pageFormat);
            this.printerJob.print();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printCalibration() {
        String string = "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";
        string = new Compression().decode(string);
        string = Geonext.convertToString(string);
        JBoardPane jBoardPane = new JBoardPane("CAL", string, this.board.geonext);
        jBoardPane.setSize(853, 711);
        this.printSVG(jBoardPane, false, new Double(this.corrTextX.getText()), new Double(this.corrTextY.getText()));
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource().equals(this.corrTextX) || caretEvent.getSource().equals(this.corrTextY)) {
            this.printerSetup();
        } else {
            this.rescale();
        }
    }

    public void printSVG() {
        this.runnable = null;
        double d = 0.9244 * new Double(this.corrTextX.getText());
        double d2 = 0.9289999999999999 * new Double(this.corrTextY.getText());
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.apache.batik.transcoder.print.PrintTranscoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName("org.apache.batik.transcoder.TranscodingHints$Key");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class<?> clazz3 = null;
            try {
                clazz3 = Class.forName("org.apache.batik.transcoder.TranscoderSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor2 = clazz3.getConstructor(new Class[0]);
            Object obj2 = constructor2.newInstance(new Object[0]);
            Method method = clazz3.getDeclaredMethod("addTranscodingHint", clazz2, class$java$lang$Object == null ? (class$java$lang$Object = JContentPrint.class$("java.lang.Object")) : class$java$lang$Object);
            Field field = clazz.getField("KEY_SHOW_PAGE_DIALOG");
            if (!this.scalRadio.isSelected()) {
                field = clazz.getField("KEY_WIDTH");
                double d3 = 35.0;
                method.invoke(obj, field.get(obj), new Float(this.board.svgX(this.board.getSize().width) * (d3 *= d2 / d * 10.0 / d2) * this.unitX));
                field = clazz.getField("KEY_SCALE_TO_PAGE");
                method.invoke(obj, field.get(obj), Boolean.FALSE);
            } else {
                field = clazz.getField("KEY_SCALE_TO_PAGE");
                method.invoke(obj, field.get(obj), Boolean.TRUE);
            }
            Class<?> clazz4 = null;
            try {
                clazz4 = Class.forName("org.apache.batik.transcoder.TranscoderInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Constructor<?> constructor3 = clazz4.getConstructor(class$java$io$Reader == null ? (class$java$io$Reader = JContentPrint.class$("java.io.Reader")) : class$java$io$Reader);
            Object var16_20 = null;
            if (!this.scalRadio.isSelected()) {
                double d4 = 1.0;
                var16_20 = constructor3.newInstance(this.board.jep.paintSVG(1.0, true, d4 *= d2 / d));
            } else {
                var16_20 = constructor3.newInstance(this.board.jep.paintSVG(1.0, true, 1.0));
            }
            Class<?> clazz5 = null;
            try {
                clazz5 = Class.forName("org.apache.batik.transcoder.TranscoderOutput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Method method2 = clazz.getDeclaredMethod("transcode", clazz4, clazz5);
            method2.invoke(obj, new Object[]{var16_20, null});
            Method method3 = clazz.getDeclaredMethod("print", new Class[0]);
            Paper paper = this.pageFormat.getPaper();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = (float)paper.getWidth();
            float f4 = (float)paper.getHeight();
            paper.setImageableArea(f, f2, f3, f4);
            this.pageFormat.setPaper(paper);
            this.pageFormat = this.printerJob.validatePage(this.pageFormat);
            System.out.println(this.printerJob.getPrintService().toString());
            this.printerJob.setPrintService(this.printerJob.getPrintService());
            this.printerJob.setPrintable((Printable)obj, this.pageFormat);
            this.printerJob.print();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.unitTextX) {
            this.unitTextX.setText(this.storedX);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

