/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import geonext.JListRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentGraph
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public JComboBox yInput;
    public Vector graphHistory = new Vector();

    public JContentGraph() {
    }

    public JContentGraph(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 5));
        jPanel.add(new JLabel("y ="));
        this.yInput = new JComboBox(jBoardPane.graphHistoryString);
        this.yInput.setEditable(true);
        this.yInput.setMaximumRowCount(5);
        this.yInput.setRenderer(new JListRenderer());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1, 15, 15));
        jPanel2.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel2.add(this.yInput);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_term") + " "));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(15, 15));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel4.add("North", new JPanel());
        this.add("North", jPanel3);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            if (this.testInput()) {
                this.board.createGraph((String)this.yInput.getSelectedItem(), "", false);
                if (!this.board.graphHistoryString.contains((String)this.yInput.getSelectedItem())) {
                    this.board.graphHistoryString.addElement((String)this.yInput.getSelectedItem());
                }
            }
            this.reset();
            this.board.getGeonextGraphDialog().dispose();
        } else if (string.equals("apply")) {
            if (this.testInput()) {
                this.board.createGraph((String)this.yInput.getSelectedItem(), "", false);
                if (!this.board.graphHistoryString.contains((String)this.yInput.getSelectedItem())) {
                    this.board.graphHistoryString.addElement((String)this.yInput.getSelectedItem());
                }
                this.reset();
            }
        } else if (string.equals("cancel")) {
            this.board.getGeonextGraphDialog().dispose();
        }
        this.board.repaint();
    }

    public void reset() {
        this.yInput.setSelectedItem("");
    }

    public boolean testInput() {
        String string = (String)this.yInput.getSelectedItem();
        C.boardName = this.board.internalName;
        boolean bl = true;
        try {
            C.GEV(new Scanner(string, false).start());
        }
        catch (Throwable throwable) {
            this.yInput.setForeground(Color.red);
            bl = false;
        }
        return bl;
    }
}

