/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Condition;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JButton;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class JContentCondition
extends JContentPanel
implements ActionListener,
ListSelectionListener {
    public JBoardPane board;
    JTextField inputField;
    JList conditionList;
    DefaultListModel conditionListModel;

    public JContentCondition() {
    }

    public JContentCondition(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        this.inputField = new JTextField();
        this.inputField.setEditable(false);
        JButton jButton = new JButton("", new ImageIcon(this.getClass().getResource("16/function_new.gif")));
        jButton.setActionCommand("new");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("", new ImageIcon(this.getClass().getResource("16/function_save.gif")));
        jButton2.setActionCommand("save");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("", new ImageIcon(this.getClass().getResource("16/mode_delete.gif")));
        jButton3.setActionCommand("delete");
        jButton3.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 10));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add("Center", this.inputField);
        jPanel2.add("East", jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(15, 15));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentcondition_input") + " "));
        jPanel3.add("Center", jPanel2);
        this.conditionListModel = new DefaultListModel();
        for (int i = 0; i < jBoardPane.conditions.size(); ++i) {
            this.conditionListModel.addElement(jBoardPane.conditions.get(i).toString());
        }
        this.conditionList = new JList(this.conditionListModel);
        this.conditionList.addListSelectionListener(this);
        this.conditionList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.conditionList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel4.add("Center", jScrollPane);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentcondition_title")));
        jPanel5.add("Center", jPanel4);
        this.add("North", jPanel3);
        this.add("Center", jPanel5);
        this.validateTree();
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("apply")) {
            this.transferConditionVector();
            this.resetInput();
        } else if (string.equals("close")) {
            this.transferConditionVector();
            this.resetInput();
        } else if (string.equals("new")) {
            this.newCondition();
        } else if (string.equals("delete")) {
            this.deleteCondition();
            this.resetInput();
        } else if (string.equals("save")) {
            this.saveCondition();
        }
        this.board.repaint();
    }

    public void reset() {
        this.conditionList.removeListSelectionListener(this);
        this.conditionListModel.removeAllElements();
        for (int i = 0; i < this.board.conditions.size(); ++i) {
            this.conditionListModel.addElement(this.board.conditions.get(i).toString());
        }
        this.conditionList.addListSelectionListener(this);
        this.resetInput();
    }

    public void transferConditionVector() {
        this.board.conditions.removeAllElements();
        for (int i = 0; i < this.conditionListModel.size(); ++i) {
            Condition condition = this.board.createCondition(this.conditionListModel.getElementAt(i).toString());
            if (condition == null) continue;
            this.board.conditions.addElement(condition);
        }
        this.board.setSaved(false);
    }

    public void deleteCondition() {
        int n = this.conditionList.getSelectedIndex();
        if (n > -1 & this.conditionListModel.size() > 0) {
            this.conditionList.removeListSelectionListener(this);
            this.conditionListModel.removeElementAt(n);
            this.conditionList.addListSelectionListener(this);
        }
        this.resetInput();
        this.inputField.setEditable(false);
    }

    public void saveCondition() {
        int n = this.conditionList.getSelectedIndex();
        if (this.conditionList.getSelectedIndex() > -1) {
            this.conditionList.removeListSelectionListener(this);
            Condition condition = this.board.createCondition(this.inputField.getText());
            if (condition != null) {
                this.conditionListModel.removeElementAt(n);
                this.conditionListModel.add(n, this.inputField.getText());
                this.inputField.setEditable(false);
            }
            this.conditionList.addListSelectionListener(this);
            this.inputField.setText("");
        } else {
            Condition condition = this.board.createCondition(this.inputField.getText());
            if (condition != null) {
                this.conditionListModel.addElement(this.inputField.getText());
                this.conditionList.setModel(this.conditionListModel);
                this.inputField.setEditable(false);
                this.inputField.setText("");
            }
        }
        this.conditionList.repaint();
    }

    public void newCondition() {
        this.resetInput();
        this.inputField.setEditable(true);
    }

    public void resetInput() {
        this.conditionList.removeListSelectionListener(this);
        this.conditionList.clearSelection();
        this.conditionList.addListSelectionListener(this);
        this.inputField.setForeground(Color.black);
        this.inputField.setText("");
        this.inputField.requestFocus();
        this.inputField.setEditable(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            this.inputField.setEditable(true);
            this.inputField.setText(this.conditionList.getSelectedValue().toString());
            this.inputField.setForeground(Color.red);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

