/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HObject;
import java.util.Stack;

public class HSymbolData {
    int attr;
    Stack patternValue;
    Stack varValue;

    public HSymbolData() {
        this.setAttributes(0);
        this.patternValue = new Stack();
        this.varValue = new Stack();
    }

    public final boolean checkAttributes(int n) {
        return (this.attr & n) == n;
    }

    public final void clearAttributes(int n) {
        this.attr &= n & 0xFFFF;
    }

    public final void createLocalPattern(HObject hObject) {
        this.patternValue.push(hObject);
    }

    public final void createLocalVar(HObject hObject) {
        this.varValue.push(hObject);
    }

    public HObject deleteLocalPattern() {
        if (this.patternValue.isEmpty()) {
            return null;
        }
        return (HObject)this.patternValue.pop();
    }

    public HObject deleteLocalVar() {
        if (this.varValue.isEmpty()) {
            return null;
        }
        return (HObject)this.varValue.pop();
    }

    public final int getAttributes() {
        return this.attr;
    }

    public final HObject getLocalPatternValue() {
        return (HObject)this.patternValue.peek();
    }

    public final HObject getLocalVarValue() {
        return (HObject)this.varValue.peek();
    }

    public final boolean hasNoLocalPattern() {
        return this.patternValue.isEmpty();
    }

    public final boolean hasNoLocalVar() {
        return this.varValue.isEmpty();
    }

    public final void setAttributes(int n) {
        this.attr |= n;
    }
}

