/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSignedNumber;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import java.text.MessageFormat;

public class HPolynomial
implements Cloneable {
    static final int maxIteration = 100;
    HFunction poly;
    HObject variable;

    private HPolynomial(HObject hObject, int n) {
        this.poly = new HFunction(C.List, n + 1);
        this.variable = hObject;
    }

    public HPolynomial(HObject hObject, HObject hObject2) {
        this.poly = new HFunction(C.List);
        this.variable = hObject2;
        if (!this.polyList(hObject)) {
            Object[] objectArray = new Object[]{hObject};
            String string = MessageFormat.format("Input: {0} is not a polynomial.", objectArray);
            throw new HThrowException(C.Error, C.Error, new HString(string));
        }
    }

    public HFunction bairstow() {
        int n;
        int n2 = this.degree();
        HFunction hFunction = C.List.f();
        double[] dArray = new double[n2 + 1];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        double[] dArray4 = new double[n2 + 1];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0E-10;
        HPolynomial hPolynomial = this.blowUp(this.degree());
        for (n = 0; n <= n2; ++n) {
            dArray[n] = ((HSignedNumber)((Object)C.EV(hPolynomial.getCoeff(n)))).doubleValue();
        }
        double d4 = dArray[n2];
        for (n = 1; n <= n2; ++n) {
            dArray2[n] = dArray[n2 - n] / d4;
        }
        dArray2[0] = 1.0;
        while (dArray2[n2] == 0.0) {
            --n2;
            hFunction.add(C.CD0);
        }
        while (n2 > 1) {
            if (n2 == 2) {
                d = dArray2[1];
                d2 = dArray2[2];
            } else {
                double d5;
                double d6;
                double d7;
                double d8;
                int n3 = 0;
                do {
                    if (++n3 >= 100) {
                        return hFunction;
                    }
                    dArray3[0] = dArray2[0];
                    dArray3[1] = dArray2[1] - d * dArray3[0];
                    for (n = 2; n <= n2; ++n) {
                        dArray3[n] = dArray2[n] - d * dArray3[n - 1] - d2 * dArray3[n - 2];
                    }
                    dArray4[0] = dArray3[0];
                    dArray4[1] = dArray3[1] - d * dArray4[0];
                    if (n2 > 3) {
                        for (n = 2; n <= n2 - 2; ++n) {
                            dArray4[n] = dArray3[n] - d * dArray4[n - 1] - d2 * dArray4[n - 2];
                        }
                    }
                    int n4 = n2 - 1;
                    int n5 = n2 - 2;
                    int n6 = n2 - 3;
                    dArray4[n4] = -d * dArray4[n5] - d2 * dArray4[n6];
                    double d9 = Math.pow(dArray4[n5], 2.0) - dArray4[n4] * dArray4[n6];
                    d4 = dArray3[n4] * dArray4[n5] - dArray3[n2] * dArray4[n6];
                    double d10 = dArray3[n2] * dArray4[n5] - dArray3[n4] * dArray4[n4];
                    if (d9 == 0.0) {
                        return hFunction;
                    }
                    d7 = d4 / d9;
                    d5 = d10 / d9;
                    d += d7;
                    d2 += d5;
                } while ((d8 = d7 < 0.0 ? -d7 : d7) + (d6 = d5 < 0.0 ? -d5 : d5) > d3);
            }
            double d11 = d * d - 4.0 * d2;
            if (d11 >= 0.0) {
                hFunction.add(new HDouble((-d - Math.sqrt(d11)) / 2.0));
                hFunction.add(new HDouble((-d + Math.sqrt(d11)) / 2.0));
            } else {
                hFunction.add(new HDoubleComplex(-d / 2.0, -Math.sqrt(-d11) / 2.0));
                hFunction.add(new HDoubleComplex(-d / 2.0, Math.sqrt(-d11) / 2.0));
            }
            n2 -= 2;
            for (n = 1; n <= n2; ++n) {
                dArray2[n] = dArray3[n];
            }
        }
        if (n2 == 1) {
            hFunction.add(new HDouble(-dArray2[1] / dArray2[0]));
        }
        return hFunction;
    }

    public HPolynomial blowUp(int n) {
        HPolynomial hPolynomial = new HPolynomial(this.variable, n);
        int n2 = 0;
        for (int i = 0; i < hPolynomial.size(); ++i) {
            if (n2 >= this.size()) {
                hPolynomial.poly.set(i, C.List.f(HInteger.valueOf(i), C.C0));
                continue;
            }
            if (this.getExp(n2).equals(HInteger.valueOf(i))) {
                hPolynomial.poly.set(i, this.poly.a[n2++]);
                continue;
            }
            hPolynomial.poly.set(i, C.List.f(HInteger.valueOf(i), C.C0));
        }
        return hPolynomial;
    }

    public final Object clone() {
        HPolynomial hPolynomial;
        try {
            hPolynomial = (HPolynomial)super.clone();
            hPolynomial.poly = (HFunction)this.poly.clone();
            hPolynomial.variable = this.variable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        return hPolynomial;
    }

    private static boolean convertFunction(HFunction hFunction, HFunction hFunction2, HObject hObject) {
        if (hFunction.head().equals(C.Add)) {
            int n;
            for (n = 0; n < hFunction.size(); ++n) {
                if (hFunction.a[n] instanceof HFunction) {
                    if (HPolynomial.monomialConvert((HFunction)hFunction.a[n], hFunction2, hObject)) continue;
                    return false;
                }
                if (hFunction.a[n].equals(hObject)) {
                    hFunction2.add(new HFunction(C.List, C.C1, C.C1));
                    continue;
                }
                hFunction2.add(new HFunction(C.List, C.C0, hFunction.a[n]));
            }
            if (hFunction2.size() > 1) {
                hFunction2.sort();
                n = 1;
                HFunction hFunction3 = (HFunction)hFunction2.a[0];
                while (n < hFunction2.len) {
                    if (hFunction3.a[0].equals(hFunction2.get(n, 0))) {
                        hFunction3.set(1, C.EV(C.Add.f(hFunction3.a[1], hFunction2.get(n, 1))));
                        hFunction2.remove(n);
                        continue;
                    }
                    hFunction3 = (HFunction)hFunction2.a[n];
                    ++n;
                }
            }
            return true;
        }
        return HPolynomial.monomialConvert(hFunction, hFunction2, hObject);
    }

    public int degree() {
        return ((HInteger)this.getExp(this.size() - 1)).intValue();
    }

    public HPolynomial divide(HPolynomial hPolynomial) {
        int n;
        int n2 = this.degree();
        int n3 = n2 - (n = hPolynomial.degree());
        if (n3 < 0) {
            return new HPolynomial((HObject)C.C0, this.variable);
        }
        HPolynomial hPolynomial2 = (HPolynomial)this.clone();
        HPolynomial hPolynomial3 = (HPolynomial)hPolynomial.clone();
        hPolynomial2 = hPolynomial2.blowUp(n2);
        hPolynomial3 = hPolynomial3.blowUp(n);
        HPolynomial hPolynomial4 = new HPolynomial(this.variable, n3);
        HObject hObject = C.EV(C.Pow.f(hPolynomial3.getCoeff(n), C.CN1));
        for (int i = n3; i >= 0; --i) {
            HObject hObject2 = C.EV(C.Multiply.f(hPolynomial2.getCoeff(n2), hObject));
            hPolynomial4.setCoeff(hObject2, i);
            for (int j = i; j <= n2; ++j) {
                hPolynomial2.setCoeff(C.EV(C.Add.f(hPolynomial2.getCoeff(j), C.Multiply.f(C.CN1, hObject2, hPolynomial3.getCoeff(j - i)))), j);
            }
            if (n2 <= 0) continue;
            --n2;
        }
        hPolynomial4.reduce(false);
        return hPolynomial4;
    }

    public HPolynomial gcd(HPolynomial hPolynomial) {
        int n;
        int n2;
        HPolynomial hPolynomial2;
        HPolynomial hPolynomial3;
        int n3 = this.degree();
        int n4 = hPolynomial.degree();
        if (n3 == 0 || n4 == 0) {
            return null;
        }
        if (n3 > n4) {
            hPolynomial3 = (HPolynomial)this.clone();
            hPolynomial2 = (HPolynomial)hPolynomial.clone();
            n2 = n3;
            n = n4;
        } else {
            hPolynomial2 = (HPolynomial)this.clone();
            hPolynomial3 = (HPolynomial)hPolynomial.clone();
            n = n3;
            n2 = n4;
        }
        hPolynomial3 = hPolynomial3.blowUp(n2);
        HPolynomial hPolynomial4 = hPolynomial2 = hPolynomial2.blowUp(n);
        HPolynomial hPolynomial5 = hPolynomial2;
        while (!hPolynomial5.isNull()) {
            hPolynomial4 = hPolynomial5;
            hPolynomial5 = hPolynomial3.mod(hPolynomial2);
            hPolynomial3 = hPolynomial2;
            hPolynomial2 = hPolynomial5;
        }
        return hPolynomial4;
    }

    public HObject getCoeff(int n) {
        return this.poly.get(n, 1);
    }

    public HObject getExp(int n) {
        return this.poly.get(n, 0);
    }

    public final HFunction getFunction() {
        return this.poly;
    }

    public boolean isNull() {
        return this.size() == 1 && this.getCoeff(0).equals(C.C0);
    }

    public HPolynomial lcm(HPolynomial hPolynomial) {
        HPolynomial hPolynomial2 = this.blowUp(this.degree());
        hPolynomial = hPolynomial.blowUp(hPolynomial.degree());
        HPolynomial hPolynomial3 = hPolynomial2.multiply(hPolynomial);
        hPolynomial3.reduce(false);
        HPolynomial hPolynomial4 = hPolynomial2.gcd(hPolynomial);
        hPolynomial4.reduce(true);
        return hPolynomial3.divide(hPolynomial4);
    }

    public HPolynomial mod(HPolynomial hPolynomial) {
        int n = this.degree();
        int n2 = hPolynomial.degree();
        int n3 = n - n2;
        HPolynomial hPolynomial2 = (HPolynomial)this.clone();
        HPolynomial hPolynomial3 = (HPolynomial)hPolynomial.clone();
        if (n < n2) {
            hPolynomial2.reduce(false);
            return hPolynomial2;
        }
        hPolynomial2 = hPolynomial2.blowUp(n);
        hPolynomial3 = hPolynomial3.blowUp(n2);
        HObject hObject = C.EV(C.Pow.f(hPolynomial3.getCoeff(n2), C.CN1));
        for (int i = n3; i >= 0; --i) {
            HObject hObject2 = C.EV(C.Multiply.f(hPolynomial2.getCoeff(i + n2), hObject));
            for (int j = n2; j >= 0; --j) {
                hPolynomial2.setCoeff(C.EV(C.Add.f(hPolynomial2.getCoeff(i + j), C.Multiply.f(C.CN1, hObject2, hPolynomial3.getCoeff(j)))), i + j);
            }
        }
        hPolynomial2.reduce(false);
        return hPolynomial2;
    }

    private static boolean monomialConvert(HFunction hFunction, HFunction hFunction2, HObject hObject) {
        HFunction hFunction3 = null;
        HFunction hFunction4 = null;
        HInteger hInteger = null;
        if (hFunction.head().equals(C.Multiply)) {
            for (int i = 0; i < hFunction.size(); ++i) {
                if (hFunction.a[i] instanceof HFunction) {
                    hFunction3 = (HFunction)hFunction.a[i];
                    if (hFunction3.size() != 2 || !hFunction3.head().equals(C.Pow)) continue;
                    if (hFunction3.a[0].equals(hObject) && hFunction3.a[1] instanceof HInteger && ((HInteger)hFunction3.a[1]).isPositive()) {
                        hFunction4 = (HFunction)hFunction.clone();
                        hFunction4.remove(i);
                        hInteger = (HInteger)hFunction3.a[1];
                        break;
                    }
                    if (!hFunction3.a[0].equals(hObject) || !(hFunction3.a[1] instanceof HDouble) || !((HDouble)hFunction3.a[1]).isPositive() || ((HDouble)hFunction3.a[1]).floor() != (HDouble)hFunction3.a[1]) continue;
                    hFunction4 = (HFunction)hFunction.clone();
                    hFunction4.remove(i);
                    hInteger = HInteger.valueOf(((HDouble)hFunction3.a[1]).intValue());
                    break;
                }
                if (!hFunction.a[i].equals(hObject)) continue;
                hFunction4 = (HFunction)hFunction.clone();
                hFunction4.remove(i);
                hInteger = C.C1;
            }
            if (hFunction4 != null) {
                if (hFunction4.isMember(hObject)) {
                    return false;
                }
                hFunction2.add(new HFunction(C.List, hInteger, hFunction4));
                return true;
            }
        }
        if (hFunction.head().equals(C.Pow) && hFunction.size() == 2 && hFunction.a[1] instanceof HInteger && ((HInteger)hFunction.a[1]).isPositive()) {
            if (hFunction.a[0].equals(hObject)) {
                hFunction2.add(new HFunction(C.List, hFunction.a[1], C.C1));
                return true;
            }
            if (!hFunction.a[0].isMember(hObject)) {
                hFunction2.add(new HFunction(C.List, hFunction.a[1], hFunction.a[0]));
                return true;
            }
        } else if (hFunction.head().equals(C.Pow) && hFunction.size() == 2 && hFunction.a[1] instanceof HDouble && ((HDouble)hFunction.a[1]).isPositive() && ((HDouble)hFunction.a[1]).floor() == (HDouble)hFunction.a[1]) {
            if (hFunction.a[0].equals(hObject)) {
                hFunction2.add(new HFunction(C.List, HInteger.valueOf(((HDouble)hFunction.a[1]).intValue()), C.C1));
                return true;
            }
            if (!hFunction.a[0].isMember(hObject)) {
                hFunction2.add(new HFunction(C.List, HInteger.valueOf(((HDouble)hFunction.a[1]).intValue()), hFunction.a[0]));
                return true;
            }
        }
        if (!hFunction.isMember(hObject)) {
            hFunction2.add(new HFunction(C.List, C.C0, hFunction));
            return true;
        }
        return false;
    }

    public HPolynomial multiply(HPolynomial hPolynomial) {
        HPolynomial hPolynomial2 = this.blowUp(this.degree());
        HPolynomial hPolynomial3 = hPolynomial.blowUp(hPolynomial.degree());
        HPolynomial hPolynomial4 = new HPolynomial((HObject)C.C0, this.variable);
        hPolynomial4 = hPolynomial4.blowUp(hPolynomial2.degree() + hPolynomial3.degree());
        for (int i = 0; i < hPolynomial2.size(); ++i) {
            for (int j = 0; j < hPolynomial3.size(); ++j) {
                hPolynomial4.setCoeff(C.EV(C.Add.f(hPolynomial4.getCoeff(i + j), C.Multiply.f(hPolynomial2.getCoeff(i), hPolynomial3.getCoeff(j)))), i + j);
            }
        }
        return hPolynomial4;
    }

    private boolean polyList(HObject hObject) {
        if (hObject instanceof HFunction) {
            return HPolynomial.convertFunction((HFunction)hObject, this.poly, this.variable);
        }
        if (hObject.equals(this.variable)) {
            this.poly.add(new HFunction(C.List, C.C1, C.C1));
            return true;
        }
        this.poly.add(new HFunction(C.List, C.C0, hObject));
        return true;
    }

    public void reduce(boolean bl) {
        int n;
        Object object = null;
        for (n = this.size() - 1; n >= 0; --n) {
            if (this.getCoeff(n).equals(C.C0)) {
                if (n == 0) continue;
                this.poly.remove(this.size() - 1);
                continue;
            }
            if (!bl) break;
            object = C.EV(C.Pow.f(this.getCoeff(n), C.CN1));
            break;
        }
        if (object != null && !object.equals(C.C1)) {
            for (n = this.size() - 1; n >= 0; --n) {
                if (this.getCoeff(n).equals(C.C0)) continue;
                this.setCoeff(C.EV(C.Multiply.f(this.getCoeff(n), (HObject)object)), n);
            }
        }
    }

    public void setCoeff(HObject hObject, int n) {
        if (this.poly.a[n] == null) {
            this.poly.set(n, C.List.f(HInteger.valueOf(n), hObject));
        } else {
            ((HFunction)this.poly.a[n]).set(1, hObject);
        }
    }

    public int size() {
        return this.poly.size();
    }

    public HFunction solve() {
        HPolynomial hPolynomial = this.blowUp(this.degree());
        HFunction hFunction = C.List.f();
        int n = this.degree();
        while (hPolynomial.poly.get(0, 1).equals(C.C0)) {
            --n;
            hPolynomial.poly.remove(0);
            hFunction.add(C.C0);
        }
        switch (n) {
            case 0: {
                return hFunction;
            }
            case 1: {
                hFunction.add(C.EV(C.Multiply.f(C.CN1, hPolynomial.getCoeff(0), C.Pow.f(hPolynomial.getCoeff(1), C.CN1))));
                return hFunction;
            }
            case 2: {
                HObject hObject = C.EV(C.Multiply.f(C.C1D2, hPolynomial.getCoeff(1), C.Pow.f(hPolynomial.getCoeff(2), C.CN1)));
                HObject hObject2 = C.EV(C.Multiply.f(C.CN1, hPolynomial.getCoeff(0), C.Pow.f(hPolynomial.getCoeff(2), C.CN1)));
                HObject hObject3 = C.EV(C.Pow.f(C.Add.f(C.Pow.f(hObject, C.C2), hObject2), C.C1D2));
                hFunction.add(C.EV(C.Add.f(C.Multiply.f(C.CN1, hObject), hObject3)));
                hFunction.add(C.EV(C.Add.f(C.Multiply.f(C.CN1, hObject), C.Multiply.f(C.CN1, hObject3))));
                return hFunction;
            }
        }
        return null;
    }

    public HFunction toFunction() {
        if (this.size() == 0) {
            return C.Add.f(C.C0);
        }
        HFunction hFunction = new HFunction(C.Add);
        if (this.size() > 0) {
            hFunction.add(C.Multiply.f(this.getCoeff(0), C.Pow.f(this.variable, this.getExp(0))));
            for (int i = 1; i < this.size(); ++i) {
                if (this.getCoeff(i).equals(C.C0)) continue;
                hFunction.add(C.Multiply.f(this.getCoeff(i), C.Pow.f(this.variable, this.getExp(i))));
            }
        }
        return hFunction;
    }
}

