/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import com.hartmath.mapping.ObjectEvaluator;
import com.hartmath.patternmatching.HRuleSet;
import geonext.Element;
import java.util.Vector;

public class HFunction
extends HArrayList
implements HObject,
Cloneable {
    public static final int NOPROPERTY = 65280;
    public static final int MATCHEQUAL = 1;
    public static final int MATCHSEQUENCE = 2;
    public static final int MATRIXFORM = 256;
    public static final int FLAT_EVALED = 16;
    public static final int ORDERLESS_EVALED = 32;
    public static final int SET = 4096;
    public static final int SETDELAYED = 8192;
    int prop;
    HSymbol symbol;
    public Element arg;
    public Vector geonextElements = new Vector();

    public HFunction(HFunction hFunction, HSymbol hSymbol, int n, int n2, boolean bl) {
        this.geonextElements = new Vector();
        this.symbol = hSymbol;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                this.add(hFunction.a[i]);
            }
        } else {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                this.add(hFunction.a[n3]);
            }
            for (n3 = n2; n3 < hFunction.len; ++n3) {
                this.add(hFunction.a[n3]);
            }
        }
    }

    public HFunction(HSymbol hSymbol) {
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, double[] dArray) {
        super(dArray.length, true);
        for (int i = 0; i < dArray.length; ++i) {
            this.a[i] = new HDouble(dArray[i]);
        }
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HDoubleComplex[] hDoubleComplexArray) {
        super(hDoubleComplexArray.length, true);
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            this.a[i] = hDoubleComplexArray[i];
        }
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, int n) {
        super(n, true);
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HArrayList hArrayList) {
        super(hArrayList);
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HObject hObject) {
        super(1, true);
        this.a[0] = hObject;
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HObject hObject, HObject hObject2) {
        super(2, true);
        this.a[0] = hObject;
        this.a[1] = hObject2;
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HObject hObject, HObject hObject2, HObject hObject3) {
        super(3, true);
        this.a[0] = hObject;
        this.a[1] = hObject2;
        this.a[2] = hObject3;
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HObject hObject, HObject hObject2, HObject hObject3, HObject hObject4) {
        super(4, true);
        this.a[0] = hObject;
        this.a[1] = hObject2;
        this.a[2] = hObject3;
        this.a[3] = hObject4;
        this.symbol = hSymbol;
    }

    public HFunction(HSymbol hSymbol, HSymbol hSymbol2, int n, int n2, int n3) {
        super(n, true);
        for (int i = 0; i < n; ++i) {
            this.a[i] = new HFunction(hSymbol2, n2);
        }
        this.prop = n3;
        this.symbol = hSymbol;
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.addAll(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    void argumentsToString(StringBuffer stringBuffer, int n, boolean bl) {
        if (this.geonextElements.size() > 0) {
            for (int i = 0; i < this.geonextElements.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(((Element)this.geonextElements.get((int)i)).name);
            }
        } else {
            for (int i = n; i < this.len; ++i) {
                if (bl && this.a[i] instanceof HFunction) {
                    stringBuffer.append(((HFunction)this.a[i]).toFullForm());
                } else {
                    this.a[i].toStringBuffer(stringBuffer);
                }
                if (i == this.len - 1) continue;
                stringBuffer.append(',');
                if ((this.prop & 0x100) != 256) continue;
                stringBuffer.append("\n ");
            }
        }
    }

    public final boolean checkAttributes(int n) {
        return this.symbol.checkAttributes(n);
    }

    public static void clearPattern(HArrayList hArrayList) {
        for (int i = 0; i < hArrayList.len; ++i) {
            ((HPattern)hArrayList.a[i]).setValue(null);
        }
    }

    public final void clearProperties(int n) {
        this.prop &= n & 0xFFFF;
    }

    public final Object clone() {
        HFunction hFunction = (HFunction)super.clone();
        hFunction.symbol = this.symbol;
        return hFunction;
    }

    public HFunction deepCopy(int n) {
        HFunction hFunction = null;
        hFunction = (HFunction)this.clone();
        if (--n > 0) {
            for (int i = 0; i < this.len; ++i) {
                if (this.get(0) instanceof HFunction) {
                    hFunction.set(i, ((HFunction)this.get(i)).deepCopy(n));
                    continue;
                }
                hFunction.set(i, this.get(i));
            }
        }
        return hFunction;
    }

    public int depth() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.len; ++i) {
            n2 = this.a[i] instanceof HFunction ? ((HFunction)this.a[i]).depth() : 1;
            if (n2 <= n) continue;
            n = n2;
        }
        return ++n;
    }

    public boolean equals(Object object) {
        if (object instanceof HFunction) {
            int n;
            HFunction hFunction = (HFunction)object;
            if (this.len != hFunction.len) {
                return false;
            }
            if (this.symbol.compareTo(hFunction.symbol) != 0) {
                return false;
            }
            for (n = 0; n < this.len; ++n) {
                if (this.a[n].equals(hFunction.a[n])) continue;
                return false;
            }
            for (n = 0; n < this.geonextElements.size(); ++n) {
                if (this.geonextElements.get(n) == hFunction.geonextElements.get(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsFromPosition(int n, HFunction hFunction, int n2) {
        if (this.len - n != hFunction.len - n2) {
            return false;
        }
        int n3 = n2;
        for (int i = n; i < this.len; ++i) {
            if (this.a[i].equals(hFunction.a[n3++])) continue;
            return false;
        }
        return true;
    }

    public HFunction evalArguments(int n) {
        HObject hObject;
        HFunction hFunction = (HFunction)this.clone();
        boolean bl = false;
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData.isSymbolicFlag() && !sessionData.isGeoNumericDefinition()) {
            HObject hObject2;
            if ((0x20 & n) != 32) {
                if (this.a[0].toString().startsWith("N")) {
                    sessionData.setGeoNumericDefinition(true);
                }
                if ((hObject2 = C.ELoop(this.a[0])) != null) {
                    hFunction.a[0] = hObject2;
                    bl = true;
                    sessionData.setGeoNumericDefinition(false);
                }
            }
            if ((0x40 & n) != 64) {
                for (int i = 1; i < this.len; ++i) {
                    if (this.a[i].toString().startsWith("N")) {
                        sessionData.setGeoNumericDefinition(true);
                    }
                    if ((hObject2 = C.ELoop(this.a[i])) == null) continue;
                    hFunction.a[i] = hObject2;
                    bl = true;
                    sessionData.setGeoNumericDefinition(false);
                }
            }
            if (bl) {
                sessionData.setGeoNumericDefinition(false);
                return hFunction;
            }
            sessionData.setGeoNumericDefinition(false);
            return null;
        }
        if ((0x20 & n) != 32 && (hObject = C.ELoop(this.a[0])) != null) {
            hFunction.a[0] = hObject;
            bl = true;
        }
        if ((0x40 & n) != 64) {
            for (int i = 1; i < this.len; ++i) {
                hObject = C.ELoop(this.a[i]);
                if (hObject == null) continue;
                hFunction.a[i] = hObject;
                bl = true;
            }
        }
        if (bl) {
            return hFunction;
        }
        return null;
    }

    public HObject evaluate() {
        HObject hObject = this.symbol.evaluateFunction(this);
        if (hObject == C.Null) {
            return null;
        }
        return hObject;
    }

    public HObject evaluateArgAttr() {
        if (this.len >= 1) {
            if (this.len == 1) {
                if ((1 & this.symbol.getAttributes()) == 1) {
                    return this.a[0];
                }
                return this.evaluateAttributes1();
            }
            if (this.len == 2) {
                return this.evaluateAttributes2();
            }
            return this.evaluateAttributes();
        }
        return null;
    }

    public HFunction evaluateAttributes() {
        int n = this.symbol.getAttributes();
        if (this.len > 0) {
            HFunction hFunction;
            if ((0x10 & n) != 16 && (hFunction = this.evalArguments(n)) != null) {
                return hFunction;
            }
            if ((0x10 & this.prop) != 16 && (8 & n) == 8 && (hFunction = this.flatten()) != null) {
                hFunction.prop |= 0x10;
                return hFunction;
            }
            if ((0x80 & n) == 128) {
                int n2 = 0;
                for (int i = 0; i < this.len; ++i) {
                    if (!(this.a[i] instanceof HFunction) || ((HFunction)this.a[i]).symbol != C.List) continue;
                    if (n2 == 0) {
                        n2 = ((HFunction)this.a[i]).len;
                        continue;
                    }
                    if (n2 == ((HFunction)this.a[i]).len) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0 && (hFunction = this.threadList(n2)) != null) {
                    return hFunction;
                }
            }
            if (this.len > 1 && (0x20 & this.prop) != 32 && (4 & n) == 4) {
                this.sort();
                this.prop |= 0x20;
            }
        }
        return null;
    }

    public HFunction evaluateAttributes1() {
        HObject hObject;
        int n = this.symbol.getAttributes();
        SessionData sessionData = SessionData.currentThreadSession();
        if (sessionData.isSymbolicFlag() && !sessionData.isGeoNumericDefinition()) {
            if ((0x10 & n) != 16 && (0x20 & n) != 32) {
                if (this.a[0].toString().startsWith("N")) {
                    sessionData.setGeoNumericDefinition(true);
                }
                HObject hObject2 = C.ELoop(this.a[0]);
                sessionData.setGeoNumericDefinition(false);
                if (hObject2 != null) {
                    return new HFunction(this.symbol, hObject2);
                }
                hObject2 = null;
            }
            if (this.a[0] instanceof HFunction) {
                HFunction hFunction = (HFunction)this.a[0];
                if ((0x10 & this.prop) != 16 && (8 & n) == 8 && this.symbol.equals(this.a[0].head())) {
                    if (this.a[0].toString().startsWith("N")) {
                        sessionData.setGeoNumericDefinition(true);
                    }
                    ((HFunction)this.a[0]).prop |= 0x10;
                    sessionData.setGeoNumericDefinition(false);
                    return (HFunction)this.a[0];
                }
                if ((0x80 & n) == 128 && this.a[0] instanceof HFunction && ((HFunction)this.a[0]).symbol == C.List) {
                    if (this.a[0].toString().startsWith("N")) {
                        sessionData.setGeoNumericDefinition(true);
                    }
                    HFunction hFunction2 = new HFunction(C.List, hFunction.len);
                    for (int i = 0; i < hFunction.len; ++i) {
                        hFunction2.a[i] = new HFunction(this.symbol, hFunction.a[i]);
                    }
                    sessionData.setGeoNumericDefinition(false);
                    return hFunction2;
                }
            }
            return null;
        }
        if ((0x10 & n) != 16 && (0x20 & n) != 32 && (hObject = C.ELoop(this.a[0])) != null) {
            return new HFunction(this.symbol, hObject);
        }
        if (this.a[0] instanceof HFunction) {
            HFunction hFunction = (HFunction)this.a[0];
            if ((0x10 & this.prop) != 16 && (8 & n) == 8 && this.symbol.equals(this.a[0].head())) {
                ((HFunction)this.a[0]).prop |= 0x10;
                return (HFunction)this.a[0];
            }
            if ((0x80 & n) == 128 && this.a[0] instanceof HFunction && ((HFunction)this.a[0]).symbol == C.List) {
                HFunction hFunction3 = new HFunction(C.List, hFunction.len);
                for (int i = 0; i < hFunction.len; ++i) {
                    hFunction3.a[i] = new HFunction(this.symbol, hFunction.a[i]);
                }
                return hFunction3;
            }
        }
        return null;
    }

    public HFunction evaluateAttributes2() {
        HFunction hFunction;
        int n = this.symbol.getAttributes();
        if ((0x10 & n) != 16 && (hFunction = this.evalArguments(n)) != null) {
            return hFunction;
        }
        if (this.a[0] instanceof HFunction || this.a[1] instanceof HFunction) {
            if ((0x10 & this.prop) != 16 && (8 & n) == 8 && (this.symbol.equals(this.a[0].head()) || this.symbol.equals(this.a[1].head()))) {
                hFunction = new HFunction(this.symbol);
                if (this.symbol.equals(this.a[0].head())) {
                    hFunction.addAll((HFunction)this.a[0]);
                } else {
                    hFunction.add(this.a[0]);
                }
                if (this.symbol.equals(this.a[1].head())) {
                    hFunction.addAll((HFunction)this.a[1]);
                } else {
                    hFunction.add(this.a[1]);
                }
                hFunction.prop |= 0x10;
                return hFunction;
            }
            if ((0x80 & n) == 128) {
                int n2 = 0;
                if (this.a[0] instanceof HFunction && ((HFunction)this.a[0]).symbol == C.List) {
                    n2 = ((HFunction)this.a[0]).len;
                }
                if (this.a[1] instanceof HFunction && ((HFunction)this.a[1]).symbol == C.List) {
                    if (n2 == 0) {
                        n2 = ((HFunction)this.a[1]).len;
                    } else if (n2 != ((HFunction)this.a[1]).len) {
                        n2 = 0;
                    }
                }
                if (n2 != 0 && (hFunction = this.threadList(n2)) != null) {
                    return hFunction;
                }
            }
        }
        if ((0x20 & this.prop) != 32 && (4 & n) == 4 && this.a[1].less(this.a[0])) {
            HObject hObject = this.a[0];
            this.a[0] = this.a[1];
            this.a[1] = hObject;
            this.prop |= 0x20;
        }
        return null;
    }

    public HFunction evaluateLHSAttr() {
        if (this.len >= 1) {
            if (this.len == 1) {
                return this.evaluateAttributes1();
            }
            if (this.len == 2) {
                return this.evaluateAttributes2();
            }
            return this.evaluateAttributes();
        }
        return null;
    }

    public int findMember(HObject hObject) {
        for (int i = 0; i < this.len; ++i) {
            if (!this.a[i].equals(hObject)) continue;
            return i;
        }
        return -1;
    }

    public HFunction flatten() {
        HFunction hFunction = new HFunction(this.symbol);
        boolean bl = false;
        for (int i = 0; i < this.len; ++i) {
            if (this.a[i] instanceof HFunction && this.symbol.equals(this.a[i].head())) {
                bl = true;
                hFunction.addAll((HFunction)this.a[i]);
                bl = true;
                continue;
            }
            hFunction.add(this.a[i]);
        }
        if (bl) {
            return hFunction;
        }
        hFunction = null;
        return null;
    }

    public Element getArg() {
        return this.arg;
    }

    public final int getAttributes() {
        return this.symbol.getAttributes();
    }

    public void getInstanceList(HArrayList hArrayList, Class clazz) {
        if (clazz.isInstance(this)) {
            hArrayList.add(this);
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.a[i] instanceof HFunction) {
                ((HFunction)this.a[i]).getInstanceList(hArrayList, clazz);
                continue;
            }
            if (!clazz.isInstance(this.a[i])) continue;
            hArrayList.add(this.a[i]);
        }
    }

    public void getPattern(HArrayList hArrayList) {
        for (int i = 0; i < this.len; ++i) {
            if (this.a[i] instanceof HFunction) {
                ((HFunction)this.a[i]).getPattern(hArrayList);
                continue;
            }
            if (!(this.a[i] instanceof HPattern) || ((HPattern)this.a[i]).getValue() != null) continue;
            boolean bl = true;
            for (int j = 0; j < hArrayList.len; ++j) {
                if (!this.a[i].equals(hArrayList.a[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hArrayList.add(this.a[i]);
        }
    }

    public final int getProperties() {
        return this.prop;
    }

    public HSymbol getSymbol() {
        return this.symbol;
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        if (this.len == 0) {
            return this.symbol.hashCode() | 0x7AAAAAAA;
        }
        return this.symbol.hashCode() << 16 | this.a[0].head().hashCode();
    }

    public final HSymbol head() {
        return this.symbol;
    }

    public final int hierarchy() {
        return 128;
    }

    public HArrayList initPattern(HArrayList hArrayList) {
        for (int i = 0; i < this.len; ++i) {
            if (this.a[i] instanceof HFunction) {
                hArrayList = ((HFunction)this.a[i]).initPattern(hArrayList);
            }
            if (!(this.a[i] instanceof HPattern) || !((HPattern)this.a[i]).isEmpty() && ((HPattern)this.a[i]).getValue() == null) continue;
            ((HPattern)this.a[i]).initValue();
            hArrayList.add(this.a[i]);
        }
        return hArrayList;
    }

    public int isEqualRule() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.len; ++n) {
            int n3;
            if (this.a[n] instanceof HPattern) {
                if (n2 != 0) continue;
                n2 = 1;
                continue;
            }
            if (!(this.a[n] instanceof HFunction) || (n3 = ((HFunction)this.a[n]).isEqualRule()) <= n2) continue;
            n2 = n3;
        }
        n = this.symbol.getAttributes();
        if (n2 > 0 && (n & 0xC) != 0) {
            this.prop &= 0xFF00;
            return 2;
        }
        switch (n2) {
            case 0: {
                this.setProperties(1);
                return 0;
            }
            case 1: {
                this.setProperties(2);
                return 1;
            }
        }
        this.prop &= 0xFF00;
        return 2;
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        if (this.symbol.equals(hSymbol)) {
            return true;
        }
        for (int i = 0; i < this.len; ++i) {
            if (!this.a[i].isHeadMember(hSymbol)) continue;
            return true;
        }
        return false;
    }

    public final boolean isList() {
        return this.symbol.equals(C.List);
    }

    public int[] isMatrix() {
        HFunction hFunction;
        int n = 0;
        int n2 = this.len;
        int n3 = 0;
        if (this.head() == C.List && n2 > 0 && this.a[0] instanceof HFunction && (hFunction = (HFunction)this.a[0]).head() == C.List) {
            n = hFunction.len;
            if (SessionData.getCurrentNumericFlag()) {
                n3 = 1;
                for (int i = 0; i < n2; ++i) {
                    if (!(this.a[i] instanceof HFunction) || this.a[i].head() != C.List || n != ((HFunction)this.a[i]).len) {
                        return null;
                    }
                    HFunction hFunction2 = (HFunction)this.a[i];
                    for (int j = 0; j < n; ++j) {
                        if (hFunction2.a[j] instanceof HDoubleComplex) {
                            if (n3 <= 0) continue;
                            n3 = -1;
                            continue;
                        }
                        if (hFunction2.a[j] instanceof HDouble) continue;
                        n3 = 0;
                    }
                }
            } else {
                for (int i = 1; i < n2; ++i) {
                    if (this.a[i] instanceof HFunction && this.a[i].head() == C.List && n == ((HFunction)this.a[i]).len) continue;
                    return null;
                }
            }
            return new int[]{n2, n, n3};
        }
        return null;
    }

    public boolean isMember(HObject hObject) {
        if (this.equals(hObject)) {
            return true;
        }
        for (int i = 0; i < this.len; ++i) {
            if (!this.a[i].isMember(hObject)) continue;
            return true;
        }
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isNumericNumber() {
        for (int i = 0; i < this.len; ++i) {
            if (this.a[i] instanceof HDouble || this.a[i] instanceof HDoubleComplex) continue;
            return false;
        }
        return true;
    }

    public final boolean isPureFunction() {
        return this.symbol.equals(C.Lambda) && this.len == 2;
    }

    public boolean isRational() {
        return false;
    }

    public int[] isVector() {
        int n = 0;
        if (this.head() == C.List) {
            if (SessionData.getCurrentNumericFlag()) {
                n = 1;
                for (int i = 0; i < this.len; ++i) {
                    if (this.a[i] instanceof HFunction && this.a[i].head() == C.List) {
                        return null;
                    }
                    if (this.a[i] instanceof HDoubleComplex) {
                        if (n <= 0) continue;
                        n = -1;
                        continue;
                    }
                    if (this.a[i] instanceof HDouble) continue;
                    n = 0;
                }
            } else {
                for (int i = 0; i < this.len; ++i) {
                    if (!(this.a[i] instanceof HFunction) || this.a[i].head() != C.List) continue;
                    return null;
                }
            }
            return new int[]{this.len, n};
        }
        return null;
    }

    public boolean less(Object object) {
        if (object instanceof HFunction) {
            int n;
            HFunction hFunction = (HFunction)object;
            int n2 = this.len;
            if (n2 > hFunction.len) {
                n2 = hFunction.len;
            }
            if ((n = this.symbol.compareTo(hFunction.symbol)) < 0) {
                return true;
            }
            if (n > 0) {
                return false;
            }
            if ((this.symbol.getAttributes() & 4) == 4) {
                int n3 = this.len - 1;
                int n4 = hFunction.len - 1;
                for (int i = 0; i < n2; ++i) {
                    if (this.a[n3].less(hFunction.a[n4])) {
                        return true;
                    }
                    if (hFunction.a[n4].less(this.a[n3])) {
                        return false;
                    }
                    --n3;
                    --n4;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (this.a[i].less(hFunction.a[i])) {
                        return true;
                    }
                    if (!hFunction.a[i].less(this.a[i])) continue;
                    return false;
                }
            }
            return this.len < hFunction.len;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public HFunction map(HObject hObject) {
        HFunction hFunction = new HFunction(this.head(), this.len);
        for (int i = 0; i < this.len; ++i) {
            hFunction.set(i, new HFunction(C.Null, this.a[i]).apply(hObject));
        }
        return hFunction;
    }

    public boolean matches(HObject hObject) {
        if (hObject instanceof HFunction) {
            if ((this.prop & 1) == 1) {
                return this.equals(hObject);
            }
            HFunction hFunction = (HFunction)hObject;
            if (this.symbol.equals(hFunction.symbol) && this.len == hFunction.len) {
                for (int i = 0; i < this.len; ++i) {
                    if (this.a[i].matches(hFunction.a[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int patternHashCode() {
        return this.symbol.hashCode() << 16 | C.Pattern.hashCode();
    }

    public int precedence() {
        return this.symbol.precedence();
    }

    public HObject replaceAll(HRuleSet hRuleSet) {
        boolean bl = false;
        HFunction hFunction = (HFunction)this.clone();
        for (int i = 0; i < this.len; ++i) {
            HObject hObject = hRuleSet.getDownRule(this.a[i]);
            if (hObject != null) {
                hFunction.set(i, hObject);
                bl = true;
                continue;
            }
            if (!(this.a[i] instanceof HFunction) || (hObject = ((HFunction)this.a[i]).replaceAll(hRuleSet)) == null) continue;
            hFunction.set(i, hObject);
            bl = true;
        }
        if (bl) {
            return hFunction;
        }
        return null;
    }

    public static void resetPattern(HArrayList hArrayList) {
        for (int i = 0; i < hArrayList.len; ++i) {
            ((HPattern)hArrayList.a[i]).resetValue();
        }
    }

    public void setArg(Element element) {
        this.arg = element;
    }

    public final void setProperties(int n) {
        this.prop |= n;
    }

    public void setSymbol(HSymbol hSymbol) {
        this.symbol = hSymbol;
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        boolean bl = false;
        HFunction hFunction = (HFunction)this.clone();
        if (this.equals(hObject)) {
            return hObject2;
        }
        if (this.symbol.equals(hObject) && hObject2 instanceof HSymbol) {
            hFunction.symbol = (HSymbol)hObject2;
            bl = true;
        }
        for (int i = 0; i < this.len; ++i) {
            HObject hObject3 = this.a[i].substitute(hObject, hObject2);
            if (hObject3 == this.a[i]) continue;
            hFunction.set(i, hObject3);
            bl = true;
        }
        if (bl) {
            return hFunction;
        }
        return this;
    }

    public HObject substituteArg(ObjectEvaluator objectEvaluator) {
        boolean bl = false;
        HFunction hFunction = (HFunction)this.clone();
        for (int i = 0; i < this.len; ++i) {
            HObject hObject = objectEvaluator.evaluate(this.a[i]);
            if (hObject == null) continue;
            hFunction.set(i, hObject);
            bl = true;
        }
        if (bl) {
            return hFunction;
        }
        return null;
    }

    public HObject substitutePattern() {
        boolean bl = false;
        HFunction hFunction = (HFunction)this.clone();
        if (!SessionData.hasNoLocalPattern(this.symbol) && SessionData.getLocalPatternValue(this.symbol) instanceof HSymbol) {
            hFunction.symbol = (HSymbol)SessionData.getLocalPatternValue(this.symbol);
            bl = true;
        }
        for (int i = 0; i < this.len; ++i) {
            HObject hObject;
            HObject hObject2 = this.a[i];
            try {
                if (this.symbol.toString().equals("If") && hObject2 instanceof HFunction && (((HFunction)hObject2).symbol.data.checkAttributes(16) || ((HFunction)hObject2).symbol.data.checkAttributes(256)) && !((HFunction)hObject2).symbol.toString().equals("If")) {
                    hObject2 = C.ELoop((HFunction)hObject2);
                }
                if (this.symbol.toString().equals("Taylor")) {
                    return C.NEV(C.NEV(this).substitutePattern());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hObject2 == null) {
                hObject2 = this.a[i];
            }
            if ((hObject = hObject2 != null ? hObject2.substitutePattern() : null) == null || hObject == hObject2) continue;
            hFunction.set(i, hObject);
            bl = true;
        }
        if (bl) {
            return hFunction;
        }
        return this;
    }

    private HFunction threadList(int n) {
        HFunction hFunction = new HFunction(C.List, n);
        for (int i = 0; i < n; ++i) {
            HFunction hFunction2 = new HFunction(this.symbol, this.len);
            for (int j = 0; j < this.len; ++j) {
                if (this.a[j].isList()) {
                    HFunction hFunction3 = (HFunction)this.a[j];
                    hFunction2.a[j] = hFunction3.a[i];
                    continue;
                }
                hFunction2.a[j] = this.a[j];
            }
            hFunction.a[i] = hFunction2;
        }
        return hFunction;
    }

    public String toFullForm() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.symbol.toString());
        stringBuffer.append('(');
        this.argumentsToString(stringBuffer, 0, true);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int toInt(int n) {
        int n2 = Integer.MIN_VALUE;
        if (this.a[n] instanceof HInteger) {
            n2 = ((HInteger)this.a[n]).intValue();
        } else if (this.a[n] instanceof HDouble) {
            n2 = ((HDouble)this.a[n]).intValue();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        try {
            if (this.checkAttributes(4096)) {
                stringBuffer.append(this.symbol.toOpString(this));
                return;
            }
            if (this.symbol == C.Slot && this.len == 1 && this.a[0] instanceof HInteger) {
                stringBuffer.append('#');
                if (!this.a[0].equals(C.C1)) {
                    this.a[0].toStringBuffer(stringBuffer);
                }
                return;
            }
            if (this.symbol == C.HoldForm && this.len == 1) {
                this.a[0].toStringBuffer(stringBuffer);
                return;
            }
            if (this.symbol == C.Lambda && this.len >= 2 && this.a[0].equals(C.Null)) {
                stringBuffer.append('(');
                this.a[1].toStringBuffer(stringBuffer);
                stringBuffer.append(")&");
                if (this.len > 2) {
                    stringBuffer.append('(');
                    this.argumentsToString(stringBuffer, 2, false);
                    stringBuffer.append(')');
                }
                return;
            }
            if (this.symbol == C.Part) {
                if (this.len != 0) {
                    if (this.a[0] instanceof HFunction && ((HFunction)this.a[0]).checkAttributes(4096)) {
                        stringBuffer.append('(');
                        this.a[0].toStringBuffer(stringBuffer);
                        stringBuffer.append(')');
                    } else {
                        this.a[0].toStringBuffer(stringBuffer);
                    }
                }
                stringBuffer.append('[');
                this.argumentsToString(stringBuffer, 1, false);
                stringBuffer.append(']');
                return;
            }
            if (this.symbol == C.List) {
                stringBuffer.append('{');
            } else {
                this.symbol.toStringBuffer(stringBuffer);
                stringBuffer.append('(');
            }
            this.argumentsToString(stringBuffer, 0, false);
            if (this.symbol == C.List) {
                stringBuffer.append('}');
            } else {
                stringBuffer.append(')');
            }
        }
        catch (Throwable throwable) {
            SessionData.appendCurrentErrorOut("Exception occured: " + throwable.getMessage());
        }
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }
}

