/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSignedNumber;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import com.hartmath.util.ExtraMath;
import com.hartmath.util.MathNumber;
import java.util.Vector;

public class HDouble
extends MathNumber
implements HObject,
HSignedNumber {
    private double value;
    public static final double SQRT2 = 1.4142135623730951;
    public static final double TWO_PI = Math.PI * 2;
    public static final double EULERGAMMA = 0.5772156649015329;
    public static final double CATALAN = 0.915965594177219;
    public static final double EPS = 2.222E-16;
    public static final double XMININ = 2.23E-308;
    public Vector geonextElements = new Vector();

    protected HDouble() {
        this.value = 0.0;
    }

    public HDouble(double d) {
        this.value = d;
    }

    public HDouble(String string) throws NumberFormatException {
        this(Double.valueOf(string));
    }

    public HObject abs() {
        return new HDouble(Math.abs(this.value));
    }

    public HDouble acosh() {
        return new HDouble(ExtraMath.acosh(this.value));
    }

    public HDouble add(HDouble hDouble) throws ArithmeticException {
        return new HDouble(this.value + hDouble.value);
    }

    public MathNumber add(MathNumber mathNumber) {
        if (mathNumber instanceof HDouble) {
            return this.add((HDouble)mathNumber);
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.add(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    public HDouble asinh() {
        return new HDouble(ExtraMath.asinh(this.value));
    }

    public HDouble atanh() {
        return new HDouble(ExtraMath.atanh(this.value));
    }

    public HObject ceil() {
        return new HDouble(Math.ceil(this.value));
    }

    public int compSignum() {
        return this.signum();
    }

    public HObject conjugate() {
        return this;
    }

    public HDouble cos() {
        return new HDouble(Math.cos(this.value));
    }

    public static HDouble cos(double d) {
        return new HDouble(Math.cos(d));
    }

    public HDouble cosh() {
        return new HDouble(ExtraMath.cosh(this.value));
    }

    public static HDouble cosh(double d) {
        return new HDouble(ExtraMath.cosh(d));
    }

    public HDouble divide(HDouble hDouble) throws ArithmeticException {
        return new HDouble(this.value / hDouble.value);
    }

    public MathNumber divide(MathNumber mathNumber) {
        if (mathNumber instanceof HDouble) {
            return this.divide((HDouble)mathNumber);
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof HDouble && Double.doubleToLongBits(((HDouble)object).value) == Double.doubleToLongBits(this.value);
    }

    public HObject evaluate() {
        SessionData sessionData = SessionData.currentSessionData();
        if (!sessionData.getNumericFlag()) {
            sessionData.setNumericFlag(true);
            return this;
        }
        return null;
    }

    public HDouble exp() {
        return new HDouble(Math.exp(this.value));
    }

    public static HDouble exp(double d) {
        return new HDouble(Math.exp(d));
    }

    public float floatValue() {
        return (float)this.value;
    }

    public HObject floor() {
        return new HDouble(Math.floor(this.value));
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public HSymbol head() {
        return C.Double;
    }

    public final int hierarchy() {
        return 1;
    }

    public HDouble IEEERemainder(HDouble hDouble) {
        return new HDouble(Math.IEEEremainder(this.value, hDouble.value));
    }

    public HObject im() {
        return C.CD0;
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean isEqual(HDouble hDouble) {
        return Double.doubleToLongBits(hDouble.value) == Double.doubleToLongBits(this.value);
    }

    public boolean isGreater(HDouble hDouble) {
        return this.value > hDouble.value;
    }

    public boolean isGreaterEqual(HDouble hDouble) {
        return this.value >= hDouble.value;
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        return C.Double.equals(hSymbol);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public boolean isLess(HDouble hDouble) {
        return this.value < hDouble.value;
    }

    public boolean isLessEqual(HDouble hDouble) {
        return this.value <= hDouble.value;
    }

    public boolean isList() {
        return false;
    }

    public boolean isMember(HObject hObject) {
        return this.equals(hObject);
    }

    public boolean isNaN() {
        return HDouble.isNaN(this.value);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public boolean isNegative() {
        return this.value < 0.0;
    }

    public boolean isNonNegative() {
        return this.value >= 0.0;
    }

    public boolean isNonZero() {
        return this.value != 0.0;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isPositive() {
        return this.value > 0.0;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isUnequal(HDouble hDouble) {
        return !this.isEqual(hDouble);
    }

    public boolean isZero() {
        return this.value == 0.0;
    }

    public boolean less(Object object) {
        if (object instanceof HDouble) {
            return this.value < ((HDouble)object).value;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public long longValue() {
        return (long)this.value;
    }

    public boolean matches(HObject hObject) {
        return this.equals(hObject);
    }

    public HDouble max(HDouble hDouble) {
        return new HDouble(Math.max(this.value, hDouble.value));
    }

    public HDouble min(HDouble hDouble) {
        return new HDouble(Math.min(this.value, hDouble.value));
    }

    public HDouble mod(HDouble hDouble) {
        return new HDouble(this.value % hDouble.value);
    }

    public HDouble multiply(HDouble hDouble) {
        return new HDouble(this.value * hDouble.value);
    }

    public MathNumber multiply(MathNumber mathNumber) {
        if (mathNumber instanceof HDouble) {
            return this.multiply((HDouble)mathNumber);
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDouble negate() {
        return new HDouble(-1.0 * this.value);
    }

    public HDouble pow(HDouble hDouble) throws ArithmeticException {
        return new HDouble(Math.pow(this.value, hDouble.value));
    }

    public int precedence() {
        if (this.value < 0.0) {
            return 100;
        }
        return 999999;
    }

    public HObject re() {
        return this;
    }

    public HObject round(HDouble hDouble) {
        return new HDouble((double)Math.round(this.value * Math.pow(10.0, hDouble.intValue())) / Math.pow(10.0, hDouble.intValue()));
    }

    public HObject round(HInteger hInteger) {
        return new HDouble((double)Math.round(this.value * Math.pow(10.0, hInteger.doubleValue())) / Math.pow(10.0, hInteger.doubleValue()));
    }

    public int signum() {
        if (this.value > 0.0) {
            return 1;
        }
        if (this.value == 0.0) {
            return 0;
        }
        return -1;
    }

    public HDouble sin() {
        return new HDouble(Math.sin(this.value));
    }

    public static HDouble sin(double d) {
        return new HDouble(Math.sin(d));
    }

    public HDouble sinh() {
        return new HDouble(ExtraMath.sinh(this.value));
    }

    public static HDouble sinh(double d) {
        return new HDouble(ExtraMath.sinh(d));
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        if (this.equals(hObject)) {
            return hObject2;
        }
        return this;
    }

    public HObject substitutePattern() {
        return this;
    }

    public HDouble subtract(HDouble hDouble) {
        return new HDouble(this.value - hDouble.value);
    }

    public MathNumber subtract(MathNumber mathNumber) {
        if (mathNumber instanceof HDouble) {
            return this.subtract((HDouble)mathNumber);
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDouble tan() {
        return new HDouble(Math.tan(this.value));
    }

    public static HDouble tan(double d) {
        return new HDouble(Math.tan(d));
    }

    public HDouble tanh() {
        return new HDouble(ExtraMath.tanh(this.value));
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(Double.toString(this.value));
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }

    public double value() {
        return this.value;
    }
}

