/*
 * $Id: LoginService.java,v 1.2 2008/07/12 11:36:50 dbarashev Exp $
 * 
 * Copyright 2004 Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * California 95054, U.S.A. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.logging.Logger;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

import org.jdesktop.beans.AbstractBean;
import org.jdesktop.ganttproject.Modification;

/**
 * <b>LoginService</b> is the abstract base class for all classes implementing
 * a login mechanism. It allows you to customize the threading behaviour used to
 * perform the login. Subclasses need to override the <b>authenticate</b>
 * method. Subclasses may implement the getUserRoles() method to return a
 * meaningful value this method will be called once upon a successful login to
 * determine the user roles. It is not defined as abstract to simplify the task
 * of implementing a login service for those who do not require this
 * functionality.
 * <p>
 * Asynchronous login behavior requires the {@code SwingWorker}. For Java 5.0,
 * users will need the
 * <a href="http://swingworker.dev.java.net/">SwingWorker BackPort</a>.
 * 
 * @author Bino George
 * @author Shai Almog
 * @author Karl Schaefer
 */
public abstract class LoginService extends AbstractBean {

    public static final Modification GP = null;
}
