package net.sourceforge.ganttproject.time.gregorian;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.language.GanttLanguage.Event;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitText;

public class DayTextFormatter extends CachingTextFormatter implements TextFormatter, GanttLanguage.Listener {
    protected TimeUnitText createTimeUnitText(Date adjustedLeft) {
        String longText = MessageFormat.format("{0}", myLongFormat.format(adjustedLeft));
        String shortText = MessageFormat.format("{0}", new Object[] { ""
                + adjustedLeft.getDate() });
        return new TimeUnitText(longText, longText, shortText);
    }

    public void languageChanged(Event event) {
        myLongFormat =  GanttLanguage.getInstance().createDateFormat("MMMM dd");
    }
    
    private SimpleDateFormat myLongFormat = GanttLanguage.getInstance().createDateFormat("MMMM dd");

}
