package net.sourceforge.ganttproject.time.gregorian;

import java.util.Calendar;
import java.util.Date;

public class BusinessHoursFramerImpl extends FramerImpl {

    private int myStartBusinessHours;
    private int myEndBusinessHours;
    private FramerImpl myDayFramer;

    public BusinessHoursFramerImpl(FramerImpl dayFramer, int startBudinessHours, int endBusinessHours) {
        super(Calendar.HOUR_OF_DAY);
        myStartBusinessHours = startBudinessHours;
        myEndBusinessHours = endBusinessHours;
        myDayFramer = dayFramer;
    }

    public Date adjustLeft(Date baseDate) {
        Date result = super.adjustLeft(baseDate);
        while (getField(result)>myEndBusinessHours) {
            result = jumpLeft(result);
        }
        if (getField(result)<myStartBusinessHours) {
            result = myDayFramer.jumpLeft(result);
            return myDayFramer.adjustRight(result);
        }
        return result;
    }

    public Date adjustRight(Date baseDate) {
        Date result = super.adjustRight(baseDate);
        while (getField(result)<myStartBusinessHours) {
            result = super.adjustRight(result);
        }
        if (getField(result)>myEndBusinessHours) {
            result = myDayFramer.adjustRight(result);
            result = adjustRight(result);
        }
        return result;
    }

    
}
