package net.sourceforge.ganttproject.print;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.gui.UIFacade;

public class PrintPreviewAction extends GPAction {
    private final GPPrintService myPrintService = new GPPrintServiceStub();
    private final IGanttProject myProject;
    private final UIFacade myUIfacade;
    
    public PrintPreviewAction(IGanttProject project, UIFacade uifacade) {
        super("preview");
        myProject = project;
        myUIfacade = uifacade;
        putValue(Action.ACCELERATOR_KEY, KeyStroke
                .getKeyStroke(KeyEvent.VK_P, MENU_MASK));
        setEnabled(myPrintService.checkPrintingAvailability().isOK());
    }
    
    protected String getLocalizedName() {
        return getI18n("preview");
    }

    protected String getIconFilePrefix() {
        return "preview_";
    }

    public void actionPerformed(ActionEvent e) {
        myPrintService.showPreview(myProject, myUIfacade.getActiveChart(), myUIfacade);
    }

}
