package net.sourceforge.ganttproject.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;

import org.xml.sax.Attributes;

public class GenericOptionTagHandler implements TagHandler {
    private final GPOption[] myOptions;

    public GenericOptionTagHandler(GPOption[] options) {
        myOptions = options;
    }
    public GenericOptionTagHandler(GPOptionGroup[] groups) {
        List<GPOption> buf = new ArrayList<GPOption>();
        for (GPOptionGroup group : groups) {
            buf.addAll(Arrays.asList(group.getOptions()));
        }
        myOptions = buf.toArray(new GPOption[0]);
    }
    public void endElement(String namespaceURI, String sName, String qName) {
        // TODO Auto-generated method stub

    }

    public void startElement(String namespaceURI, String sName, String qName,
            Attributes attrs) throws FileFormatException {
        if ("option".equals(qName)) {
            final String id = attrs.getValue("id"); 
            final String value = attrs.getValue("value");
            if (id==null || value==null) {
                return;
            }
            for (GPOption nextOption : myOptions) {
                if (nextOption.getID().equals(id)) {
                    nextOption.loadPersistentValue(value);
                }
            }
        }
    }

}
