package net.sourceforge.ganttproject.gui.taskproperties;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class ListAndFieldsPanel<T> {
    private EditableList<T> myList;
    private JComponent myFields;
    private JPanel myPanel;
    public ListAndFieldsPanel(EditableList<T> list, JComponent fields) {
        myList = list;
        myFields = fields;
    }
    public JPanel getComponent() {
        if (myPanel==null) {
            SpringLayout layout = new SpringLayout();
            myPanel = new JPanel(layout);
            
            JComponent depsComponent = myList.getComponent();
            myPanel.add(depsComponent);
            myPanel.add(myFields);
            
            layout.putConstraint(SpringLayout.WEST, depsComponent, 0, SpringLayout.WEST, myPanel);
            layout.putConstraint(SpringLayout.NORTH, depsComponent, 0, SpringLayout.NORTH, myPanel);
            layout.putConstraint(SpringLayout.WEST, myFields, 5, SpringLayout.EAST,depsComponent);
            layout.putConstraint(SpringLayout.NORTH, myFields, 0, SpringLayout.NORTH, myPanel);
            
            layout.putConstraint(SpringLayout.EAST, myPanel, 0, SpringLayout.EAST, myFields);
            layout.putConstraint(SpringLayout.SOUTH, myPanel, 0, SpringLayout.SOUTH, depsComponent);
            
        }
        return myPanel;
    }
}
