/*
 * Created on 02.04.2005
 */
package net.sourceforge.ganttproject.gui.options.model;

import java.beans.PropertyChangeListener;

/**
 * @author bard
 */
public interface GPOption extends ChangeValueDispatcher {
    String getID();

    void lock();

    void commit();

    void rollback();
    
    String getPersistentValue();
    
    void loadPersistentValue(String value);
    
    boolean isChanged();

    void setWritable(boolean isWritable);
    boolean isWritable();
    void addPropertyChangeListener(PropertyChangeListener listener);
    void removePropertyChangeListener(PropertyChangeListener listener);
    String PROPERTY_IS_WRITABLE = "isWritable";
    UIHint getUIHint(Class hintClass);
}
