// CheckBoxList.java
//   
package net.sourceforge.ganttproject.gui.options;

import javax.swing.*;


import net.sourceforge.ganttproject.gui.options.model.BooleanOption;

import java.awt.*;
import java.awt.event.*;

public class JCheckBoxList extends JList {
	//   
	public JCheckBoxList(ListModel model) {
		super(model);
		initList();
	}
	public JCheckBoxList(Object[] data) {
		super(data);
		initList();
	}
	public JCheckBoxList(java.util.Vector data) {
		super(data);
		initList();
	}
	//   
	private void initList() {
		setCellRenderer(new CheckBoxCellRenderer());
		setSelectionMode(
			ListSelectionModel.SINGLE_SELECTION);
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
			//   
			if ( e.getClickCount() == 1 &&
			SwingUtilities.isLeftMouseButton(e) ) {
					//   
					int pos = 
					  locationToIndex(e.getPoint());
					BooleanOption cbel =
						(BooleanOption)getModel().
							getElementAt(pos);
					cbel.toggle();
					repaint();
				}
			}
		});
	}
	//   
	public static class CheckBoxCellRenderer 
		 extends JCheckBox implements ListCellRenderer {
		public Component getListCellRendererComponent(
			JList list, Object data, int idx,
				boolean isSelected, boolean hasFocus) {
			// ,     
			BooleanOption
				cbel = (BooleanOption)data;
			//  
			if ( isSelected ) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
			} else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}
			setSelected(cbel.isChecked());
			setText(cbel.getID());
			setMaximumSize(new Dimension(300, getPreferredSize().height));
			return this;
		}
	}
}

