package net.sourceforge.ganttproject.gui;

import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.taskproperties.IPropertySheetComponent;

import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.view.View;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class HierarchicalPropertySheetBuilderImpl implements IPropertySheetBuilder {
    public HierarchicalPropertySheetBuilderImpl() {
    }
    
    public JComponent buildPlanePage(GPOptionGroup optionGroup) {
        return buildPlanePage(new GPOptionGroup[] {optionGroup});
    }
    public JComponent buildPlanePage(GPOptionGroup[] optionGroups) {
        JXTaskPaneContainer taskPane = new JXTaskPaneContainer();
//        try {
//            LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
//        } catch (InstantiationException e) {
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        } catch (ClassNotFoundException e) {
//            e.printStackTrace();
//        }
        taskPane.setBackground(UIManager.getColor("Label.background"));
        OptionsPageBuilder builder = new OptionsPageBuilder();
        for (GPOptionGroup nextGroup : optionGroups) {
            nextGroup.setTitled(false);
            JComponent nextComponent = builder.createGroupComponent(nextGroup);
            JXTaskPane nextTaskPane = new JXTaskPane();
            nextTaskPane.add(nextComponent);
            nextTaskPane.setTitle(builder.getI18N().getOptionGroupLabel(nextGroup));
            taskPane.add(nextTaskPane);
        }
        return taskPane;
    }
    
    public JComponent buildPropertySheets(IPropertySheetComponent[] components) {
        DockingManager.getDockingPort("task-properties");
        DefaultDockingPort dockingPort = new DefaultDockingPort("tabs");
        //dockingPort.setPreferredSize(new Dimension(300, 300));

        Dockable first = null;
        for (final IPropertySheetComponent nextComponent : components) {
            JComponent nextUIComponent = (JComponent) nextComponent.getAdapter(JComponent.class);
            nextUIComponent.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(nextUIComponent, BorderLayout.CENTER);
            View view  = new View(nextComponent.getTitle(), nextComponent.getTitle());
            view.add(panel);
            Dockable nextDockable = DockingManager.registerDockable((Dockable)view);
            
            if (first==null) {
                first = nextDockable;
            }
            DockingManager.dock(nextDockable, (DockingPort)dockingPort, DockingConstants.CENTER_REGION);
            
        }
        first.getDockingProperties().setActive(true);
        return dockingPort;
    }    
}
