/*
 * Created on 02.05.2005
 */
package net.sourceforge.ganttproject.export;

import java.util.List;

import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;

/**
 * @author bard
 */
public abstract class TaskVisitor {
    public String visit(TaskManager taskManager) throws Exception {
        StringBuffer out = new StringBuffer();
        visit(taskManager.getTaskHierarchy().getRootTask(), taskManager.getTaskHierarchy(), out);
        return out.toString();
    }

    public String visit(List/*<Task>*/ tasks) throws Exception {
    	StringBuffer result = new StringBuffer();
    	for (int i=0; i<tasks.size(); i++) {
    		Task next = (Task) tasks.get(i);
    		String nextSerialized = serializeTask(
    				next,
    				next.getManager().getTaskHierarchy().getDepth(next));
    		result.append(nextSerialized);
    	}
    	return result.toString();
    }
    
    void visit(Task task, TaskContainmentHierarchyFacade hierarchy, StringBuffer out) throws Exception {
        Task[] nestedTasks = task.getManager().getTaskHierarchy()
                .getNestedTasks(task);
        for (int i = 0; i < nestedTasks.length; i++) {
            Task next = nestedTasks[i];
            int depth = hierarchy.getDepth(next) - 1;
            String nextSerialized = serializeTask(next, depth);
            out.append(nextSerialized);
            visit(next, hierarchy, out);
        }
    }

    protected abstract String serializeTask(Task t, int depth) throws Exception;
}
