/*
 * Created on 02.05.2005
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import java.util.List;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.export.Stylesheet.StylesheetType;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;

/**
 * @author bard
 */
public interface Exporter {

    String getFileTypeDescription();

    GPOptionGroup getOptions();

    GPOptionGroup[] getSecondaryOptions();

    String getFileNamePattern();

    void run(File outputFile, List/*<Task>*/ selectedTasks, ExportFinalizationJob finalizationJob) throws Exception;

    // File proposeOutputFile(IGanttProject project);
    String proposeFileExtension();

    String[] getFileExtensions();

    void setContext(IGanttProject project, UIFacade uiFacade, StylesheetType stylesheetType);

    Stylesheet[] getStylesheets();

    void setStylesheet(Stylesheet stylesheet);
}
