package net.sourceforge.ganttproject.datafilter.task;

import java.util.List;

import net.sourceforge.ganttproject.datafilter.FilteringEventListener;
import net.sourceforge.ganttproject.datafilter.TaskGroup;
import net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.io.GPSaver;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.task.event.TaskListener;
import net.sourceforge.ganttproject.datafilter.AutoFix;

/**
 * Interface for getting groups of task filters.  
 * 
 * Created 12.2007
 * 
 * @author Joanna Muras 
 */
public interface FilteredTasks extends TaskListener, GPOptionChangeListener {

    /** Return groups of task filters */
    TaskGroup[] getTaskGroups();
    void addFilteringEventListener(FilteringEventListener listener);
    void removeFilteringEventListener(FilteringEventListener listener);
    /** Return filter name */
    String getName();
    
    String getDescription();
    /** Return filter settings - options */
    GPOptionGroup[] getSettings();
    /** Return auto fix options */
    List<AutoFix> getAutoFixList();
    void updateAutoFixList();
    GPSaver getSaver();
    TagHandler getLoader();
}
