package net.sourceforge.ganttproject.datafilter;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;

public class FilterOptionGroup extends GPOptionGroup {

    private final List<GPOptionChangeListener> myListenerList = new ArrayList<GPOptionChangeListener>();

    public FilterOptionGroup(String id, GPOption[] options) {
        super(id, options);
    }
    
    /**
     * This method allows classes to register for FilteringEvent
     */ 
    public void addOptionChangeEventListener(GPOptionChangeListener listener) {
        myListenerList.add(listener);
    }

    /**
     * This method allows classes to unregister for FilteringEvent
     */ 
    public void removeOptionChangeEventListener(GPOptionChangeListener listener) {
        myListenerList.remove(listener);
    }

    protected void fireFilteringEvent() {
        for (GPOptionChangeListener listener : myListenerList) { 
            listener.optionsChanged();
        }
    }
    
    @Override
    public void commit() {
        super.commit();
        fireFilteringEvent();
    }

}
