/*
 * Created on 24.01.2005
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.util.Date;

import net.sourceforge.ganttproject.calendar.GPCalendar.DayType;
import net.sourceforge.ganttproject.task.TaskLength;

/**
 * @author bard
 */
public class DayTypeAlternance {

    private DayType myDayType;

    private TaskLength myDuration;

    private Date myEnd;
    
    private Color backgroundColor;

    DayTypeAlternance(DayType dayType, TaskLength duration, Date endDate, Color backgroundColor) {
        myDayType = dayType;
        myDuration = duration;
        myEnd = endDate;
        this.backgroundColor = backgroundColor;
    }

    public Date getEnd() {
        return myEnd;
    }
    public DayType getDayType() {
        return myDayType;
    }

    public TaskLength getDuration() {
        return myDuration;
    }
    
    public Color getBackgroundColor(){
        return this.backgroundColor;
    }

    public String toString() {
        return "period length=" + myDuration.getLength() + " ("
                + myDuration.getTimeUnit().getName() + ")" + " is"
                + (myDayType == DayType.WEEKEND ? " holiday" : " working\n");
    }
}
