/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import net.sourceforge.helpgui.HelpGui;
import net.sourceforge.helpgui.gui.HelpView;
import net.sourceforge.helpgui.gui.TestRolloverButton;
import net.sourceforge.helpgui.page.PageBookMarks;
import net.sourceforge.helpgui.parser.TocOpen;
import net.sourceforge.helpgui.util.Language;
import net.sourceforge.helpgui.util.Out;

public class MainFrame
extends JFrame
implements ActionListener {
    public String version = "1.0";
    protected JButton jbPrev;
    protected JButton jbNext;
    protected JButton jbHome;
    protected JButton jbPrint;
    protected JButton jbBookmarks;
    JMenu menuBookMarks;
    protected HelpView helpView;
    public static String helpPath = "/docs/help";
    public static String iconsPath = "java";

    public MainFrame() {
        super("Help Gui");
        this.initFrame("/docs/help", iconsPath);
    }

    public MainFrame(String helpPath) {
        super("Help Gui");
        this.initFrame(helpPath, iconsPath);
    }

    public MainFrame(String helpPath, String iconsPath) {
        super("Help Gui");
        this.initFrame(helpPath, iconsPath);
    }

    public void initFrame(String helpPath, String iconsPath) {
        if (helpPath.endsWith("/")) {
            helpPath = helpPath.substring(0, helpPath.length() - 1);
        }
        MainFrame.helpPath = helpPath;
        MainFrame.iconsPath = iconsPath;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainFrame.this.setVisible(false);
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(Language.getInstance().getText("file"));
        JMenu menuAction = new JMenu(Language.getInstance().getText("action"));
        this.menuBookMarks = new JMenu(Language.getInstance().getText("bookmarks"));
        menuBar.add(menuFile);
        menuBar.add(menuAction);
        menuBar.add(this.menuBookMarks);
        menuFile.add(Language.getInstance().getText("print")).addActionListener(this);
        menuFile.add(Language.getInstance().getText("quit")).addActionListener(this);
        menuAction.add(Language.getInstance().getText("previous")).addActionListener(this);
        menuAction.add(Language.getInstance().getText("next")).addActionListener(this);
        menuAction.add(Language.getInstance().getText("home")).addActionListener(this);
        this.menuBookMarks.add(Language.getInstance().getText("addBookmarks")).addActionListener(this);
        this.menuBookMarks.addSeparator();
        this.jbPrev = new TestRolloverButton(new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/previous.gif")));
        this.jbNext = new TestRolloverButton(new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/next.gif")));
        this.jbHome = new TestRolloverButton(new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/home.gif")));
        this.jbPrint = new TestRolloverButton(new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/print.gif")));
        this.jbBookmarks = new TestRolloverButton(new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/addbookmarks.gif")));
        this.jbPrev.addActionListener(this);
        this.jbNext.addActionListener(this);
        this.jbHome.addActionListener(this);
        this.jbPrint.addActionListener(this);
        this.jbBookmarks.addActionListener(this);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setBorderPainted(true);
        toolBar.add(this.jbPrev);
        toolBar.add(this.jbNext);
        toolBar.add(this.jbHome);
        toolBar.add(this.jbPrint);
        toolBar.add(this.jbBookmarks);
        this.jbPrev.setToolTipText(Language.getInstance().getText("previous"));
        this.jbNext.setToolTipText(Language.getInstance().getText("next"));
        this.jbHome.setToolTipText(Language.getInstance().getText("home"));
        this.jbPrint.setToolTipText(Language.getInstance().getText("print"));
        this.jbBookmarks.setToolTipText(Language.getInstance().getText("addBookmarks"));
        this.helpView = new HelpView();
        GridBagLayout gbPanel = new GridBagLayout();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        this.getContentPane().setLayout(gbPanel);
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        gbcPanel.gridwidth = 1;
        gbcPanel.gridheight = 1;
        gbcPanel.fill = 3;
        gbcPanel.weightx = 1.0;
        gbcPanel.weighty = 0.0;
        gbcPanel.anchor = 17;
        gbPanel.setConstraints(toolBar, gbcPanel);
        this.getContentPane().add(toolBar);
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 1;
        gbcPanel.gridwidth = 1;
        gbcPanel.gridheight = 1;
        gbcPanel.fill = 1;
        gbcPanel.weightx = 1.0;
        gbcPanel.weighty = 1.0;
        gbcPanel.anchor = 10;
        gbPanel.setConstraints(this.helpView, gbcPanel);
        this.getContentPane().add(this.helpView);
        this.pack();
        this.setLocation(100, 100);
        Out.msg("Construction of the GUI", Out.OK);
        try {
            TocOpen opener = new TocOpen(this.helpView);
            opener.load();
            Out.msg("Loading the Table of Content", Out.OK);
        }
        catch (Exception e) {
            Out.msg("Table of Content XML parsing", Out.FAILED);
            System.out.println(e);
        }
        this.helpView.goHome();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getSource().equals(this.jbPrev)) {
                this.helpView.previousPage();
            } else if (e.getSource().equals(this.jbNext)) {
                this.helpView.nextPage();
            } else if (e.getSource().equals(this.jbHome)) {
                this.helpView.goHome();
            } else if (e.getSource().equals(this.jbPrint)) {
                this.helpView.print();
            } else if (e.getSource().equals(this.jbBookmarks)) {
                this.addBookMarks();
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = e.getActionCommand();
            if (arg.equals(Language.getInstance().getText("previous"))) {
                this.helpView.previousPage();
            } else if (arg.equals(Language.getInstance().getText("next"))) {
                this.helpView.nextPage();
            } else if (arg.equals(Language.getInstance().getText("home"))) {
                this.helpView.goHome();
            } else if (arg.equals(Language.getInstance().getText("print"))) {
                this.helpView.print();
            } else if (arg.equals(Language.getInstance().getText("quit"))) {
                this.quit();
            } else if (arg.equals(Language.getInstance().getText("addBookmarks"))) {
                this.addBookMarks();
            } else {
                this.helpView.updatePage(PageBookMarks.getInstance().getBookMark((JMenuItem)e.getSource()), true);
            }
        }
    }

    public void quit() {
        if (HelpGui.debug) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public void addBookMarks() {
        JMenuItem menuItem = new JMenuItem(this.helpView.getCurrentPage().toString());
        menuItem.addActionListener(this);
        this.menuBookMarks.add(menuItem);
        PageBookMarks.getInstance().addBookMark(menuItem, this.helpView.getCurrentPage());
    }
}

