/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterChainRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFilterElementBridge
extends AbstractSVGBridge
implements FilterBridge,
ErrorConstants {
    public String getLocalName() {
        return "filter";
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode) {
        Rectangle2D filterRegion = SVGUtilities.convertFilterChainRegion(filterElement, filteredElement, filteredNode, ctx);
        Filter sourceGraphic = filteredNode.getGraphicsNodeRable(true);
        sourceGraphic = new PadRable8Bit(sourceGraphic, filterRegion, PadMode.ZERO_PAD);
        FilterChainRable8Bit filterChain = new FilterChainRable8Bit(sourceGraphic, filterRegion);
        float[] filterRes = SVGUtilities.convertFilterRes(filterElement, ctx);
        filterChain.setFilterResolutionX((int)filterRes[0]);
        filterChain.setFilterResolutionY((int)filterRes[1]);
        HashMap<String, Filter> filterNodeMap = new HashMap<String, Filter>(11);
        filterNodeMap.put("SourceGraphic", sourceGraphic);
        Filter in = SVGFilterElementBridge.buildFilterPrimitives(filterElement, filterRegion, filteredElement, filteredNode, sourceGraphic, filterNodeMap, ctx);
        if (in == sourceGraphic) {
            return null;
        }
        filterChain.setSource(in);
        return filterChain;
    }

    protected static Filter buildFilterPrimitives(Element filterElement, Rectangle2D filterRegion, Element filteredElement, GraphicsNode filteredNode, Filter in, Map filterNodeMap, BridgeContext ctx) {
        LinkedList<URL> refs = new LinkedList<URL>();
        Filter newIn;
        while ((newIn = SVGFilterElementBridge.buildLocalFilterPrimitives(filterElement, filterRegion, filteredElement, filteredNode, in, filterNodeMap, ctx)) == in) {
            URL url;
            String uri = XLinkSupport.getXLinkHref((Element)filterElement);
            if (uri.length() == 0) {
                return in;
            }
            SVGOMDocument doc = (SVGOMDocument)filterElement.getOwnerDocument();
            try {
                url = new URL(doc.getURLObject(), uri);
            }
            catch (MalformedURLException ex) {
                throw new BridgeException(filterElement, "uri.malformed", new Object[]{uri});
            }
            if (SVGFilterElementBridge.contains(refs, url)) {
                throw new BridgeException(filterElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.add(url);
            filterElement = ctx.getReferencedElement(filterElement, uri);
        }
        return newIn;
    }

    protected static Filter buildLocalFilterPrimitives(Element filterElement, Rectangle2D filterRegion, Element filteredElement, GraphicsNode filteredNode, Filter in, Map filterNodeMap, BridgeContext ctx) {
        Node n = filterElement.getFirstChild();
        while (n != null) {
            Element e;
            Bridge bridge;
            if (n.getNodeType() == 1 && (bridge = ctx.getBridge(e = (Element)n)) != null && bridge instanceof FilterPrimitiveBridge) {
                FilterPrimitiveBridge filterBridge = (FilterPrimitiveBridge)bridge;
                Filter filterNode = filterBridge.createFilter(ctx, e, filteredElement, filteredNode, in, filterRegion, filterNodeMap);
                if (filterNode == null) {
                    return null;
                }
                in = filterNode;
            }
            n = n.getNextSibling();
        }
        return in;
    }

    private static boolean contains(List urls, URL key) {
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (!url.sameFile(key) || !url.getRef().equals(key.getRef())) continue;
            return true;
        }
        return false;
    }
}

