/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FocusManager;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.SVGBridgeExtension;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentViewport;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.SystemColorSupport;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterPool;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class BridgeContext
implements ErrorConstants,
CSSContext {
    protected Document document;
    protected GVTBuilder gvtBuilder;
    protected Map interpreterMap = new HashMap(7);
    private Map fontFamilyMap;
    protected Map viewportMap = new HashMap();
    protected List viewportStack = new LinkedList();
    protected UserAgent userAgent;
    protected HashMap elementNodeMap;
    protected HashMap nodeElementMap;
    protected HashMap namespaceURIMap;
    protected InterpreterPool interpreterPool;
    protected DocumentLoader documentLoader;
    protected Dimension2D documentSize;
    protected TextPainter textPainter;
    protected boolean dynamic;
    protected UpdateManager updateManager;
    private static InterpreterPool sharedPool = new InterpreterPool();
    protected List eventListenerList = new LinkedList();
    protected EventListener domCharacterDataModifiedListener;
    protected EventListener domAttrModifiedEventListener;
    protected EventListener domNodeInsertedEventListener;
    protected EventListener domNodeRemovedEventListener;
    protected CSSEngineListener cssPropertiesChangedListener;
    protected FocusManager focusManager;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$bridge$BridgeExtension;

    protected BridgeContext() {
    }

    public BridgeContext(UserAgent userAgent) {
        this(userAgent, sharedPool, new DocumentLoader(userAgent));
    }

    public BridgeContext(UserAgent userAgent, DocumentLoader loader) {
        this(userAgent, sharedPool, loader);
    }

    public BridgeContext(UserAgent userAgent, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewportMap.put(userAgent, new UserAgentViewport(userAgent));
        this.interpreterPool = interpreterPool;
        this.documentLoader = documentLoader;
        documentLoader.setBridgeContext(this);
        BridgeContext.registerSVGBridges(this);
    }

    protected void initializeDocument(Document document) {
        SVGOMDocument doc = (SVGOMDocument)document;
        CSSEngine eng = doc.getCSSEngine();
        if (eng == null) {
            SVGDOMImplementation impl = (SVGDOMImplementation)doc.getImplementation();
            eng = impl.createCSSEngine(doc, this);
            doc.setCSSEngine(eng);
            eng.setMedia(this.userAgent.getMedia());
            String uri = this.userAgent.getUserStyleSheetURI();
            if (uri != null) {
                try {
                    URL url = new URL(uri);
                    eng.setUserAgentStyleSheet(eng.parseStyleSheet(url, "all"));
                }
                catch (MalformedURLException e) {
                    this.userAgent.displayError(e);
                }
            }
            eng.setAlternateStyleSheet(this.userAgent.getAlternateStyleSheet());
        }
    }

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document document) {
        if (this.document != document) {
            this.fontFamilyMap = null;
        }
        this.document = document;
    }

    public Map getFontFamilyMap() {
        if (this.fontFamilyMap == null) {
            this.fontFamilyMap = new HashMap();
        }
        return this.fontFamilyMap;
    }

    protected void setFontFamilyMap(Map fontFamilyMap) {
        this.fontFamilyMap = fontFamilyMap;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    protected void setGVTBuilder(GVTBuilder gvtBuilder) {
        this.gvtBuilder = gvtBuilder;
    }

    public InterpreterPool getInterpreterPool() {
        return this.interpreterPool;
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    protected void setInterpreterPool(InterpreterPool interpreterPool) {
        this.interpreterPool = interpreterPool;
    }

    public Interpreter getInterpreter(String language) {
        if (this.document == null) {
            throw new RuntimeException("Unknown document");
        }
        Interpreter interpreter = (Interpreter)this.interpreterMap.get(language);
        if (interpreter == null) {
            interpreter = this.interpreterPool.createInterpreter(this.document, language);
            this.interpreterMap.put(language, interpreter);
        }
        return interpreter;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    protected void setDocumentLoader(DocumentLoader newDocumentLoader) {
        this.documentLoader = newDocumentLoader;
    }

    public Dimension2D getDocumentSize() {
        return this.documentSize;
    }

    protected void setDocumentSize(Dimension2D d) {
        this.documentSize = d;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean b) {
        this.dynamic = b;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    protected void setUpdateManager(UpdateManager um) {
        this.updateManager = um;
    }

    public Element getReferencedElement(Element e, String uri) {
        try {
            SVGDocument document = (SVGDocument)e.getOwnerDocument();
            URIResolver ur = new URIResolver(document, this.documentLoader);
            Element ref = ur.getElement(uri, e);
            if (ref == null) {
                throw new BridgeException(e, "uri.badTarget", new Object[]{uri});
            }
            return ref;
        }
        catch (MalformedURLException ex) {
            throw new BridgeException(e, "uri.malformed", new Object[]{uri});
        }
        catch (InterruptedIOException ex) {
            throw new InterruptedBridgeException();
        }
        catch (IOException ex) {
            throw new BridgeException(e, "uri.io", new Object[]{uri});
        }
        catch (IllegalArgumentException ex) {
            throw new BridgeException(e, "uri.referenceDocument", new Object[]{uri});
        }
        catch (SecurityException ex) {
            throw new BridgeException(e, "uri.unsecure", new Object[]{uri});
        }
    }

    public Viewport getViewport(Element e) {
        if (this.viewportStack != null) {
            if (this.viewportStack.size() == 0) {
                return (Viewport)this.viewportMap.get(this.userAgent);
            }
            return (Viewport)this.viewportStack.get(0);
        }
        e = SVGUtilities.getParentElement(e);
        while (e != null) {
            Viewport viewport = (Viewport)this.viewportMap.get(e);
            if (viewport != null) {
                return viewport;
            }
            e = SVGUtilities.getParentElement(e);
        }
        return (Viewport)this.viewportMap.get(this.userAgent);
    }

    public void openViewport(Element e, Viewport viewport) {
        this.viewportMap.put(e, viewport);
        if (this.viewportStack == null) {
            this.viewportStack = new LinkedList();
        }
        this.viewportStack.add(0, viewport);
    }

    public void closeViewport(Element e) {
        this.viewportStack.remove(0);
        if (this.viewportStack.size() == 0) {
            this.viewportStack = null;
        }
    }

    public void bind(Element element, GraphicsNode node) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new HashMap();
            this.nodeElementMap = new HashMap();
        }
        this.elementNodeMap.put(element, node);
        this.nodeElementMap.put(node, element);
    }

    public void unbind(Element element) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode node = (GraphicsNode)this.elementNodeMap.get(element);
        this.elementNodeMap.remove(element);
        this.nodeElementMap.remove(node);
    }

    public GraphicsNode getGraphicsNode(Element element) {
        if (this.elementNodeMap != null) {
            return (GraphicsNode)this.elementNodeMap.get(element);
        }
        return null;
    }

    public Element getElement(GraphicsNode node) {
        if (this.nodeElementMap != null) {
            return (Element)this.nodeElementMap.get(node);
        }
        return null;
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String namespaceURI = element.getNamespaceURI();
        String localName = element.getLocalName();
        HashMap localNameMap = (HashMap)this.namespaceURIMap.get(namespaceURI = namespaceURI == null ? "" : namespaceURI);
        if (localNameMap == null) {
            return null;
        }
        Bridge bridge = (Bridge)localNameMap.get(localName);
        if (this.dynamic) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    public boolean hasGraphicsNodeBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return false;
        }
        String namespaceURI = element.getNamespaceURI();
        String localName = element.getLocalName();
        HashMap localNameMap = (HashMap)this.namespaceURIMap.get(namespaceURI = namespaceURI == null ? "" : namespaceURI);
        if (localNameMap == null) {
            return false;
        }
        return localNameMap.get(localName) instanceof GraphicsNodeBridge;
    }

    public Bridge getBridge(String namespaceURI, String localName) {
        HashMap localNameMap = (HashMap)this.namespaceURIMap.get(namespaceURI);
        if (localNameMap == null) {
            return null;
        }
        Bridge bridge = (Bridge)localNameMap.get(localName);
        if (this.dynamic) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    public void putBridge(String namespaceURI, String localName, Bridge bridge) {
        HashMap<String, Bridge> localNameMap;
        if (!namespaceURI.equals(bridge.getNamespaceURI()) || !localName.equals(bridge.getLocalName())) {
            throw new Error("Invalid Bridge: " + namespaceURI + "/" + bridge.getNamespaceURI() + " " + localName + "/" + bridge.getLocalName() + " " + bridge.getClass());
        }
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap();
        }
        if ((localNameMap = (HashMap<String, Bridge>)this.namespaceURIMap.get(namespaceURI = namespaceURI == null ? "" : namespaceURI)) == null) {
            localNameMap = new HashMap<String, Bridge>();
            this.namespaceURIMap.put(namespaceURI, localNameMap);
        }
        localNameMap.put(localName, bridge);
    }

    public void putBridge(Bridge bridge) {
        this.putBridge(bridge.getNamespaceURI(), bridge.getLocalName(), bridge);
    }

    public void removeBridge(String namespaceURI, String localName) {
        if (this.namespaceURIMap == null) {
            return;
        }
        HashMap localNameMap = (HashMap)this.namespaceURIMap.get(namespaceURI = namespaceURI == null ? "" : namespaceURI);
        if (localNameMap != null) {
            localNameMap.remove(localName);
            if (localNameMap.isEmpty()) {
                this.namespaceURIMap.remove(namespaceURI);
                if (this.namespaceURIMap.isEmpty()) {
                    this.namespaceURIMap = null;
                }
            }
        }
    }

    public void addDOMListeners() {
        EventTarget evtTarget = (EventTarget)((Object)this.document);
        this.domAttrModifiedEventListener = new DOMAttrModifiedEventListener();
        evtTarget.addEventListener("DOMAttrModified", this.domAttrModifiedEventListener, true);
        this.domNodeInsertedEventListener = new DOMNodeInsertedEventListener();
        evtTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedEventListener, true);
        this.domNodeRemovedEventListener = new DOMNodeRemovedEventListener();
        evtTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
        evtTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, true);
        this.focusManager = new FocusManager(this.document);
        SVGOMDocument svgDocument = (SVGOMDocument)this.document;
        CSSEngine cssEngine = svgDocument.getCSSEngine();
        this.cssPropertiesChangedListener = new CSSPropertiesChangedListener();
        cssEngine.addCSSEngineListener(this.cssPropertiesChangedListener);
    }

    protected void storeEventListener(EventTarget t, String s, EventListener l, boolean b) {
        this.eventListenerList.add(new EventListenerMememto(t, s, l, b));
    }

    public void dispose() {
        Iterator iter = this.eventListenerList.iterator();
        while (iter.hasNext()) {
            EventListenerMememto m = (EventListenerMememto)iter.next();
            m.target.removeEventListener(m.eventType, m.listener, m.useCapture);
        }
        EventTarget evtTarget = (EventTarget)((Object)this.document);
        evtTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedEventListener, true);
        evtTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedEventListener, true);
        evtTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        evtTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, true);
        SVGOMDocument svgDocument = (SVGOMDocument)this.document;
        CSSEngine cssEngine = svgDocument.getCSSEngine();
        if (cssEngine != null) {
            cssEngine.removeCSSEngineListener(this.cssPropertiesChangedListener);
            cssEngine.dispose();
        }
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
    }

    protected static SVGContext getSVGContext(Node node) {
        if (node instanceof SVGOMElement) {
            return ((SVGOMElement)node).getSVGContext();
        }
        return null;
    }

    protected static BridgeUpdateHandler getBridgeUpdateHandler(Node node) {
        SVGContext ctx = BridgeContext.getSVGContext(node);
        return ctx == null ? null : (BridgeUpdateHandler)((Object)ctx);
    }

    public Value getSystemColor(String ident) {
        return SystemColorSupport.getSystemColor((String)ident);
    }

    public float getLighterFontWeight(float f) {
        return this.userAgent.getLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return this.userAgent.getBolderFontWeight(f);
    }

    public float getPixelUnitToMillimeter() {
        return this.userAgent.getPixelUnitToMillimeter();
    }

    public float getPixelToMillimeter() {
        return this.getPixelUnitToMillimeter();
    }

    public float getMediumFontSize() {
        return this.userAgent.getMediumFontSize();
    }

    public float getBlockWidth(Element elt) {
        return this.getViewport(elt).getWidth();
    }

    public float getBlockHeight(Element elt) {
        return this.getViewport(elt).getHeight();
    }

    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        this.userAgent.checkLoadExternalResource(resourceURL, docURL);
    }

    public static void registerSVGBridges(BridgeContext ctx) {
        UserAgent ua = ctx.getUserAgent();
        Iterator iter = BridgeContext.getBridgeExtensions().iterator();
        while (iter.hasNext()) {
            BridgeExtension be = (BridgeExtension)iter.next();
            be.registerTags(ctx);
            ua.registerExtension(be);
        }
    }

    public static synchronized List getBridgeExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        extensions.add(new SVGBridgeExtension());
        Iterator iter = Service.providers(class$org$apache$batik$bridge$BridgeExtension == null ? (class$org$apache$batik$bridge$BridgeExtension = BridgeContext.class$("org.apache.batik.bridge.BridgeExtension")) : class$org$apache$batik$bridge$BridgeExtension);
        block0: while (iter.hasNext()) {
            BridgeExtension lbe;
            BridgeExtension be = (BridgeExtension)iter.next();
            float priority = be.getPriority();
            ListIterator<BridgeExtension> li = extensions.listIterator();
            do {
                if (li.hasNext()) continue;
                li.add(be);
                continue block0;
            } while (!((lbe = (BridgeExtension)li.next()).getPriority() > priority));
            li.previous();
            li.add(be);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CSSPropertiesChangedListener
    implements CSSEngineListener {
        protected CSSPropertiesChangedListener() {
        }

        public void propertiesChanged(CSSEngineEvent evt) {
            SVGContext ctx = BridgeContext.getSVGContext(evt.getElement());
            if (ctx != null && ctx instanceof BridgeUpdateHandler) {
                ((BridgeUpdateHandler)((Object)ctx)).handleCSSEngineEvent(evt);
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            Node node = (Node)((Object)evt.getTarget());
            while (node != null && !(node instanceof SVGOMElement)) {
                node = node.getParentNode();
            }
            BridgeUpdateHandler h = BridgeContext.getBridgeUpdateHandler(node);
            if (h != null) {
                try {
                    h.handleDOMCharacterDataModified((MutationEvent)evt);
                }
                catch (Exception e) {
                    BridgeContext.this.userAgent.displayError(e);
                }
            }
        }
    }

    protected class DOMNodeRemovedEventListener
    implements EventListener {
        protected DOMNodeRemovedEventListener() {
        }

        public void handleEvent(Event evt) {
            Node node = (Node)((Object)evt.getTarget());
            BridgeUpdateHandler h = BridgeContext.getBridgeUpdateHandler(node);
            if (h != null) {
                try {
                    h.handleDOMNodeRemovedEvent((MutationEvent)evt);
                }
                catch (Exception e) {
                    BridgeContext.this.userAgent.displayError(e);
                }
            }
        }
    }

    protected class DOMNodeInsertedEventListener
    implements EventListener {
        protected DOMNodeInsertedEventListener() {
        }

        public void handleEvent(Event evt) {
            MutationEvent me = (MutationEvent)evt;
            BridgeUpdateHandler h = BridgeContext.getBridgeUpdateHandler(me.getRelatedNode());
            if (h != null) {
                try {
                    h.handleDOMNodeInsertedEvent(me);
                }
                catch (Exception e) {
                    BridgeContext.this.userAgent.displayError(e);
                }
            }
        }
    }

    protected class DOMAttrModifiedEventListener
    implements EventListener {
        protected DOMAttrModifiedEventListener() {
        }

        public void handleEvent(Event evt) {
            Node node = (Node)((Object)evt.getTarget());
            BridgeUpdateHandler h = BridgeContext.getBridgeUpdateHandler(node);
            if (h != null) {
                try {
                    h.handleDOMAttrModifiedEvent((MutationEvent)evt);
                }
                catch (Exception e) {
                    BridgeContext.this.userAgent.displayError(e);
                }
            }
        }
    }

    protected static class EventListenerMememto {
        public EventTarget target;
        public EventListener listener;
        public boolean useCapture;
        public String eventType;

        public EventListenerMememto(EventTarget t, String s, EventListener l, boolean b) {
            this.target = t;
            this.eventType = s;
            this.listener = l;
            this.useCapture = b;
        }
    }
}

