/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Stub;

public class ConsecutiveCallsAcceptanceTest
extends MockObjectTestCase {
    public void testCanEasilySpecifySequenceOfStubsForSameMethod() {
        Mock mock = this.mock(Greeter.class);
        Greeter greeter = (Greeter)mock.proxy();
        mock.expects(this.atLeastOnce()).method("greeting").withNoArguments().will(this.onConsecutiveCalls(this.returnValue("hello"), this.returnValue("bonjour"), this.returnValue("guten Tag")));
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"hello", (String)greeter.greeting());
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"bonjour", (String)greeter.greeting());
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"guten Tag", (String)greeter.greeting());
    }

    public void testCanSpecifySequenceUsingArrayOfStubs() {
        Mock mock = this.mock(Greeter.class);
        Greeter greeter = (Greeter)mock.proxy();
        mock.expects(this.atLeastOnce()).method("greeting").withNoArguments().will(this.onConsecutiveCalls(new Stub[]{this.returnValue("hello"), this.returnValue("bonjour"), this.returnValue("guten Tag")}));
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"hello", (String)greeter.greeting());
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"bonjour", (String)greeter.greeting());
        ConsecutiveCallsAcceptanceTest.assertEquals((String)"guten Tag", (String)greeter.greeting());
    }

    public static interface Greeter {
        public String greeting();
    }
}

