/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.Filter;
import org.jdesktop.swing.decorator.FilterPipeline;

public abstract class Sorter
extends Filter {
    private boolean ascending = true;

    public Sorter() {
        this(0, true);
    }

    public Sorter(int col, boolean ascending) {
        super(col);
        this.setAscending(ascending);
    }

    protected abstract void adopt(Sorter var1);

    public void interpose(FilterPipeline filters, ComponentAdapter adapter, Sorter oldSorter) {
        if (filters != null) {
            filters.setSorter(this);
        }
        this.adopt(oldSorter);
        this.assign(filters);
        this.assign(adapter);
        this.refresh(oldSorter == null);
    }

    public int compare(int row1, int row2) {
        int result = this.compare(row1, row2, this.getColumnIndex());
        return this.ascending ? result : -result;
    }

    private int compare(int row1, int row2, int col) {
        Object o1 = this.getInputValue(row1, col);
        Object o2 = this.getInputValue(row2, col);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        if (o1 instanceof Boolean) {
            boolean b1;
            block10: {
                Boolean bool1 = (Boolean)o1;
                b1 = bool1;
                Boolean bool2 = (Boolean)o2;
                boolean b2 = bool2;
                if (b1 != b2) break block10;
                return 0;
            }
            try {
                if (b1) {
                    return 1;
                }
                return -1;
            }
            catch (ClassCastException ex) {
                System.out.println("Column class mismatch: " + o1.getClass() + " can't be compared to " + o2.getClass());
            }
        } else {
            return o1.toString().compareTo(o2.toString());
        }
        return 0;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.refresh();
    }

    public void toggle() {
        this.ascending = !this.ascending;
        this.refresh();
    }
}

