/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.PipelineEvent;
import org.jdesktop.swing.decorator.PipelineListener;

public class HighlighterPipeline {
    protected EventListenerList listenerList = new EventListenerList();
    private List highlighters;
    private static final Highlighter nullHighlighter = new Highlighter(null, null);
    static /* synthetic */ Class class$0;

    public HighlighterPipeline(Highlighter[] inList) {
        List<Highlighter> copy = Arrays.asList((Highlighter[])inList.clone());
        this.highlighters = new ArrayList(copy.size());
        this.highlighters.addAll(copy);
        this.reindexHighlighters();
    }

    private void reindexHighlighters() {
        Iterator iter = this.highlighters.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Highlighter hl = (Highlighter)iter.next();
            hl.order = i++;
        }
    }

    public void addHighlighter(Highlighter hl) {
        this.addHighlighter(hl, false);
    }

    public void addHighlighter(Highlighter hl, boolean prepend) {
        if (this.highlighters == null) {
            this.highlighters = new ArrayList();
        }
        if (prepend) {
            this.highlighters.add(0, hl);
        } else {
            this.highlighters.add(this.highlighters.size(), hl);
        }
        this.reindexHighlighters();
    }

    public void removeHighlighter(Highlighter hl) {
        boolean success = this.highlighters.remove(hl);
    }

    public Highlighter[] getHighlighters() {
        return this.highlighters.toArray(new Highlighter[this.highlighters.size()]);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void addPipelineListener(PipelineListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removePipelineListener(PipelineListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public PipelineListener[] getPipelineListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PipelineListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireContentsChanged(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        PipelineEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jdesktop.swing.decorator.PipelineListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new PipelineEvent(source, 0);
                }
                ((PipelineListener)listeners[i + 1]).contentsChanged(e);
            }
            i -= 2;
        }
    }

    public Component apply(Component stamp, ComponentAdapter adapter) {
        stamp = nullHighlighter.highlight(stamp, adapter);
        Iterator iter = this.highlighters.iterator();
        while (iter.hasNext()) {
            Highlighter hl = (Highlighter)iter.next();
            stamp = hl.highlight(stamp, adapter);
        }
        return stamp;
    }
}

