/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swing.data.DataLoader;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.MetaDataProvider;
import org.jdesktop.swing.data.TabularDataTextLoader;
import org.jdesktop.swing.event.MessageEvent;
import org.jdesktop.swing.event.MessageListener;
import org.jdesktop.swing.event.ProgressEvent;
import org.jdesktop.swing.event.ProgressListener;

public class TabularDataModel
extends AbstractTableModel
implements MetaDataProvider {
    private URL sourceURL;
    private DataLoader loader;
    private MetaData[] columnMetaData;
    private Vector rows;
    private boolean loading = false;
    private boolean readOnly = false;
    private PropertyChangeListener columnMetaDataListener;
    private PropertyChangeSupport pcs;

    public TabularDataModel() {
        this(0);
    }

    public TabularDataModel(int columnCount) {
        this.init();
        this.setColumnCount(columnCount);
    }

    public TabularDataModel(String urlName) throws MalformedURLException {
        this();
        this.setSource(urlName);
    }

    public TabularDataModel(URL sourceURL) {
        this();
        this.setSource(sourceURL);
    }

    public TabularDataModel(String urlName, int columnCount) throws MalformedURLException {
        this(columnCount);
        this.setSource(urlName);
    }

    private void init() {
        this.columnMetaDataListener = new MetaDataChangeListener();
        this.pcs = new PropertyChangeSupport(this);
        this.setLoader(new TabularDataTextLoader());
    }

    public void setSource(String urlName) throws MalformedURLException {
        this.setSource(new URL(urlName));
    }

    public void setSource(URL sourceURL) {
        URL oldSource = this.sourceURL;
        this.sourceURL = sourceURL;
        this.pcs.firePropertyChange("source", oldSource, sourceURL);
    }

    public URL getSource() {
        return this.sourceURL;
    }

    public void setLoader(DataLoader loader) {
        DataLoader oldLoader = this.loader;
        this.loader = loader;
        this.pcs.firePropertyChange("loader", oldLoader, loader);
    }

    public DataLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() {
        TabularDataModel tabularDataModel = this;
        synchronized (tabularDataModel) {
            this.ensureMetaDataInitialized();
            return this.columnMetaData.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnCount(int columnCount) {
        if (columnCount < 0) {
            throw new IllegalArgumentException("column count, " + columnCount + " is < 0");
        }
        int oldColumnCount = this.columnMetaData != null ? this.columnMetaData.length : 0;
        TabularDataModel tabularDataModel = this;
        synchronized (tabularDataModel) {
            int i;
            if (this.columnMetaData != null) {
                i = 0;
                while (i < this.columnMetaData.length) {
                    this.columnMetaData[i].removePropertyChangeListener(this.columnMetaDataListener);
                    ++i;
                }
            }
            this.columnMetaData = new MetaData[columnCount];
            i = 0;
            while (i < this.columnMetaData.length) {
                this.columnMetaData[i] = new MetaData("column" + i);
                this.columnMetaData[i].addPropertyChangeListener(this.columnMetaDataListener);
                ++i;
            }
            this.rows = new Vector();
        }
        this.fireTableStructureChanged();
        this.pcs.firePropertyChange("columnCount", oldColumnCount, columnCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData getColumnMetaData(int columnIndex) {
        TabularDataModel tabularDataModel = this;
        synchronized (tabularDataModel) {
            this.ensureMetaDataInitialized();
            return this.columnMetaData[columnIndex];
        }
    }

    public MetaData getMetaData(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        return this.getColumnMetaData(columnIndex);
    }

    public MetaData[] getMetaData() {
        this.ensureMetaDataInitialized();
        MetaData[] metaDataCopy = new MetaData[this.columnMetaData.length];
        System.arraycopy(this.columnMetaData, 0, metaDataCopy, 0, this.columnMetaData.length);
        return metaDataCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnMetaData(int columnIndex, MetaData metaData) {
        TabularDataModel tabularDataModel = this;
        synchronized (tabularDataModel) {
            if (this.columnMetaData[columnIndex] != null) {
                this.columnMetaData[columnIndex].removePropertyChangeListener(this.columnMetaDataListener);
            }
            this.columnMetaData[columnIndex] = metaData;
            metaData.addPropertyChangeListener(this.columnMetaDataListener);
        }
        this.fireTableStructureChanged();
    }

    private void ensureMetaDataInitialized() {
        if (this.columnMetaData == null || this.columnMetaData.length == 0) {
            this.initializeMetaData();
        }
    }

    private boolean initializeMetaData() {
        if (this.sourceURL != null && this.loader != null) {
            try {
                InputStream is = this.sourceURL.openStream();
                this.loader.loadMetaData(this, is);
                is.close();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        this.ensureMetaDataInitialized();
        return this.columnMetaData[columnIndex].getElementClass();
    }

    public String getColumnName(int columnIndex) {
        this.ensureMetaDataInitialized();
        return this.columnMetaData[columnIndex].getLabel();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        this.ensureMetaDataInitialized();
        return !this.columnMetaData[columnIndex].isReadOnly();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] row = (Object[])this.rows.get(rowIndex);
        return row[columnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.isCellEditable(rowIndex, columnIndex)) {
            Vector vector = this.rows;
            synchronized (vector) {
                Object[] row = (Object[])this.rows.get(rowIndex);
                row[columnIndex] = value;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        } else {
            throw new RuntimeException("row " + rowIndex + " column " + columnIndex + " is not editable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int rowIndex) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.rows.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(int firstRowIndex, int lastRowIndex) {
        if (lastRowIndex < firstRowIndex) {
            throw new IllegalArgumentException("lastRowIndex, " + lastRowIndex + " cannot be less than firstRowIndex, " + firstRowIndex);
        }
        Vector vector = this.rows;
        synchronized (vector) {
            int deletedRowCount = lastRowIndex - firstRowIndex + 1;
            int i = 0;
            while (i < deletedRowCount) {
                this.rows.remove(firstRowIndex);
                ++i;
            }
            this.fireTableRowsDeleted(firstRowIndex, lastRowIndex);
        }
    }

    public void insertRow(int rowIndex, Object[] row) {
        this.insertRowImpl(rowIndex, row);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRows(int rowIndex, List rows) {
        Vector vector = this.rows;
        synchronized (vector) {
            int i = 0;
            while (i < rows.size()) {
                Object[] row = (Object[])rows.get(i);
                this.insertRowImpl(rowIndex + i, row);
                ++i;
            }
            this.fireTableRowsInserted(rowIndex, rowIndex + rows.size() - 1);
        }
    }

    public void addRow(Object[] row) {
        int rowIndex = this.rows.size();
        this.insertRowImpl(rowIndex, row);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void addRows(List rows) {
        this.insertRows(this.rows.size(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadRows(List rows) {
        Vector vector = this.rows;
        synchronized (vector) {
            int rowIndex = this.rows.size();
            this.rows.addAll(rows);
            this.fireTableRowsInserted(rowIndex, rowIndex + rows.size());
        }
    }

    private void insertRowImpl(int rowIndex, Object[] row) {
        int rowLength = this.getColumnCount();
        Object[] newRow = new Object[rowLength];
        System.arraycopy(row, 0, newRow, 0, rowLength);
        this.rows.insertElementAt(newRow, rowIndex);
    }

    public void startLoading() throws IOException {
        if (this.sourceURL == null) {
            throw new IllegalStateException("data cannot be loaded when source URL is null");
        }
        if (this.isLoading()) {
            return;
        }
        this.ensureMetaDataInitialized();
        InputStream is = this.sourceURL.openStream();
        this.setLoading(true);
        this.rows.clear();
        MessageAdapter a = new MessageAdapter(is);
        this.loader.addProgressListener(a);
        this.loader.addMessageListener(a);
        this.loader.startLoading(this, is);
    }

    public boolean isLoading() {
        return this.loading;
    }

    private void setLoading(boolean loading) {
        boolean oldLoading = this.loading;
        this.loading = loading;
        this.pcs.firePropertyChange("loading", oldLoading, loading);
    }

    public Object[] getRow(int rowIndex) {
        int columnCount = this.getColumnCount();
        Object[] row = new Object[columnCount];
        System.arraycopy((Object[])this.rows.get(rowIndex), 0, row, 0, columnCount);
        return row;
    }

    public int getColumnIndex(String columnName) {
        int i = 0;
        while (i < this.columnMetaData.length) {
            if (this.columnMetaData[i].getName().equals(columnName)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("\"" + columnName + "\" not found in tabular data object");
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private class MessageAdapter
    implements ProgressListener,
    MessageListener {
        private InputStream is;

        public MessageAdapter(InputStream is) {
            this.is = is;
        }

        public void progressStarted(ProgressEvent event) {
        }

        public void progressIncremented(ProgressEvent event) {
        }

        public void progressEnded(ProgressEvent event) {
            this.cleanup((DataLoader)event.getSource());
        }

        public void message(MessageEvent event) {
            if (event.getThrowable() != null) {
                this.cleanup((DataLoader)event.getSource());
            }
            System.out.println(event);
        }

        private void cleanup(DataLoader loader) {
            loader.removeProgressListener(this);
            TabularDataModel.this.setLoading(false);
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class MetaDataChangeListener
    implements PropertyChangeListener {
        private MetaDataChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("elementClass") || propertyName.equals("name")) {
                TabularDataModel.this.fireTableStructureChanged();
            }
        }
    }
}

