/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swing.data.Converter;
import org.jdesktop.swing.data.Converters;
import org.jdesktop.swing.data.Validator;

public class MetaData {
    protected String name;
    protected Class klass;
    protected String label;
    protected Converter converter;
    protected Object decodeFormat;
    protected Object encodeFormat;
    protected boolean readOnly;
    protected int minValueCount;
    protected int maxValueCount;
    protected int displayWidth;
    protected ArrayList validators;
    protected Map customProps;
    protected PropertyChangeSupport pcs;
    static /* synthetic */ Class class$0;

    public MetaData() {
        this("value");
    }

    public MetaData(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.klass = clazz;
        this.converter = null;
        this.decodeFormat = null;
        this.encodeFormat = null;
        this.readOnly = false;
        this.minValueCount = 0;
        this.maxValueCount = 1;
        this.displayWidth = 24;
        this.validators = null;
        this.customProps = new HashMap();
        this.name = name;
    }

    public MetaData(String name, Class klass) {
        this(name);
        this.klass = klass;
    }

    public MetaData(String name, Class klass, String label) {
        this(name, klass);
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, name);
    }

    public Class getElementClass() {
        return this.klass;
    }

    public void setElementClass(Class klass) {
        Class oldClass = this.klass;
        this.klass = klass;
        this.firePropertyChange("elementClass", oldClass, klass);
    }

    public String getLabel() {
        return this.label == null ? this.name : this.label;
    }

    public void setLabel(String label) {
        String oldLabel = this.label;
        this.label = label;
        this.firePropertyChange("label", oldLabel, label);
    }

    public Converter getConverter() {
        if (this.converter == null) {
            return Converters.get(this.klass);
        }
        return this.converter;
    }

    public void setConverter(Converter converter) {
        Converter oldConverter = this.converter;
        this.converter = converter;
        this.firePropertyChange("converter", oldConverter, converter);
    }

    public Object getDecodeFormat() {
        return this.decodeFormat;
    }

    public void setDecodeFormat(Object format) {
        Object oldDecodeFormat = this.decodeFormat;
        this.decodeFormat = format;
        this.firePropertyChange("decodeFormat", oldDecodeFormat, format);
    }

    public Object getEncodeFormat() {
        return this.encodeFormat;
    }

    public void setEncodeFormat(Object format) {
        Object oldEncodeFormat = this.encodeFormat;
        this.encodeFormat = format;
        this.firePropertyChange("encodeFormat", oldEncodeFormat, format);
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int displayWidth) {
        if (displayWidth < 0) {
            throw new IllegalArgumentException("displayWidth must be >= 0");
        }
        int oldDisplayWidth = this.displayWidth;
        this.displayWidth = displayWidth;
        this.firePropertyChange("displayWidth", oldDisplayWidth, displayWidth);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        boolean oldReadOnly = this.readOnly;
        this.readOnly = readOnly;
        this.firePropertyChange("readOnly", oldReadOnly, readOnly);
    }

    public int getMinValueCount() {
        return this.minValueCount;
    }

    public void setMinValueCount(int minValueCount) {
        int oldMinValueCount = this.minValueCount;
        this.minValueCount = minValueCount;
        this.firePropertyChange("minValueCount", oldMinValueCount, minValueCount);
    }

    public boolean isRequired() {
        return this.getMinValueCount() > 0;
    }

    public void setRequired(boolean required) {
        if (required) {
            if (this.getMinValueCount() <= 0) {
                this.setMinValueCount(1);
            }
        } else if (this.getMinValueCount() > 0) {
            this.setMinValueCount(0);
        }
    }

    public int getMaxValueCount() {
        return this.maxValueCount;
    }

    public void setMaxValueCount(int maxValueCount) {
        int oldMaxValueCount = this.maxValueCount;
        this.maxValueCount = maxValueCount;
        this.firePropertyChange("maxValueCount", oldMaxValueCount, maxValueCount);
    }

    public void setCustomProperty(String propertyName, Object value) {
        if (propertyName == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        Object oldValue = this.customProps.get(propertyName);
        this.customProps.put(propertyName, value);
        this.firePropertyChange(propertyName, oldValue, value);
    }

    public Object getCustomProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        return this.customProps.get(propertyName);
    }

    public Object getCustomProperty(String propertyName, Object defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        return this.customProps.containsKey(propertyName) ? this.customProps.get(propertyName) : defaultValue;
    }

    public void removeCustomProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        Object oldValue = this.customProps.get(propertyName);
        this.customProps.remove(propertyName);
        this.firePropertyChange(propertyName, oldValue, null);
    }

    public String[] getCustomPropertyKeys() {
        Object[] keys = this.customProps.keySet().toArray();
        String[] propertyNames = new String[keys.length];
        System.arraycopy(keys, 0, propertyNames, 0, keys.length);
        return propertyNames;
    }

    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
            if (this.validators.size() == 0) {
                this.validators = null;
            }
        }
    }

    public Validator[] getValidators() {
        if (this.validators != null) {
            return this.validators.toArray(new Validator[1]);
        }
        return new Validator[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(pcl);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.pcs != null) {
            return this.pcs.getPropertyChangeListeners();
        }
        return new PropertyChangeListener[0];
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (newValue != oldValue) {
            this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (newValue != oldValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

