/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.net.MalformedURLException;
import java.net.URL;

public class Link
implements Comparable {
    private String text;
    private URL url;
    private String target;
    private boolean visited = false;

    public Link(String text, String target, URL url) {
        this.setText(text);
        this.setTarget(target);
        this.setURL(url);
    }

    public Link(String text, String target, String template, String[] args) {
        this.setText(text);
        this.setTarget(target);
        this.setURL(this.createURL(template, args));
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.getURL().toString();
    }

    public void setURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL for link cannot be null");
        }
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    private URL createURL(String template, String[] args) {
        URL url = null;
        try {
            String urlStr = template;
            int i = 0;
            while (i < args.length) {
                urlStr = urlStr.replaceAll("@\\{" + (i + 1) + "\\}", args[i]);
                ++i;
            }
            url = new URL(urlStr);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return "_blank";
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (obj == this) {
            return 0;
        }
        return this.text.compareTo(((Link)obj).text);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof Link) {
            Link other = (Link)obj;
            if (!this.getText().equals(other.getText())) {
                return false;
            }
            if (!this.getTarget().equals(other.getTarget())) {
                return false;
            }
            return this.getURL().equals(other.getURL());
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = 37 * result + (this.getText() == null ? 0 : this.getText().hashCode());
        result = 37 * result + (this.getTarget() == null ? 1 : this.getTarget().hashCode());
        result = 37 * result + (this.getURL() == null ? 2 : this.getURL().hashCode());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append("url=");
        buffer.append(this.url);
        buffer.append(", target=");
        buffer.append(this.target);
        buffer.append(", text=");
        buffer.append(this.text);
        buffer.append("]");
        return buffer.toString();
    }
}

