/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static Calendar CALENDAR = Calendar.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date endOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 23);
            calendar.set(14, 999);
            calendar.set(13, 59);
            calendar.set(12, 59);
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date startOfDay(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long startOfDayInMillis(long date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            calendar.set(11, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long endOfDayInMillis(long date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            calendar.set(11, 23);
            calendar.set(14, 999);
            calendar.set(13, 59);
            calendar.set(12, 59);
            return calendar.getTimeInMillis();
        }
    }

    public static Date nextDay(Date date) {
        return new Date(DateUtils.addDays(date.getTime(), 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addDays(long time, int amount) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(time);
            calendar.add(5, amount);
            return calendar.getTimeInMillis();
        }
    }

    public static long nextDay(long date) {
        return DateUtils.addDays(date, 1);
    }

    public static long nextWeek(long date) {
        return DateUtils.addDays(date, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDaysDiff(long t1, long t2, boolean checkOverflow) {
        Calendar calendar;
        if (t1 > t2) {
            long tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(t1);
            int delta = 0;
            while (calendar.getTimeInMillis() < t2) {
                calendar.add(5, 1);
                ++delta;
            }
            if (checkOverflow && calendar.getTimeInMillis() > t2) {
                --delta;
            }
            return delta;
        }
    }

    public static int getDaysDiff(long t1, long t2) {
        return DateUtils.getDaysDiff(t1, t2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFirstOfYear(long date) {
        Calendar calendar;
        boolean ret = false;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            int currentYear = calendar.get(1);
            calendar.add(5, -1);
            int yesterdayYear = calendar.get(1);
            ret = currentYear != yesterdayYear;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFirstOfMonth(long date) {
        Calendar calendar;
        boolean ret = false;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            int currentMonth = calendar.get(2);
            calendar.add(5, -1);
            int yesterdayMonth = calendar.get(2);
            ret = currentMonth != yesterdayMonth;
        }
        return ret;
    }

    public static long previousDay(long date) {
        return DateUtils.addDays(date, -1);
    }

    public static long previousWeek(long date) {
        return DateUtils.addDays(date, -7);
    }

    public static long getPreviousDay(long date, int startOfWeek) {
        return DateUtils.getDay(date, startOfWeek, -1);
    }

    public static long getNextDay(long date, int startOfWeek) {
        return DateUtils.getDay(date, startOfWeek, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getDay(long date, int startOfWeek, int increment) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            int day = calendar.get(7);
            while (day != startOfWeek) {
                calendar.add(5, increment);
                day = calendar.get(7);
            }
            return DateUtils.startOfDayInMillis(calendar.getTimeInMillis());
        }
    }

    public static long getPreviousMonth(long date) {
        return DateUtils.incrementMonth(date, -1);
    }

    public static long getNextMonth(long date) {
        return DateUtils.incrementMonth(date, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long incrementMonth(long date, int increment) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            calendar.add(2, increment);
            return calendar.getTimeInMillis();
        }
    }

    public static long getStartOfMonth(long date) {
        return DateUtils.getMonth(date, -1);
    }

    public static long getEndOfMonth(long date) {
        return DateUtils.getMonth(date, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMonth(long date, int increment) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            if (increment == -1) {
                calendar.set(5, 1);
                return DateUtils.startOfDayInMillis(calendar.getTimeInMillis());
            }
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.add(14, -1);
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDayOfWeek(long date) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(date);
            return calendar.get(7);
        }
    }
}

