/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.jdesktop.swing.Application;
import org.jdesktop.swing.actions.Debug;

public class ServerAction
extends AbstractAction {
    private static final String PARAMS = "action-params";
    private static final String HEADERS = "action-headers";
    private static final String URL = "action-url";
    private static final String URL_CACHE = "_URL-CACHE__";

    public ServerAction() {
        this("action");
    }

    public ServerAction(String name) {
        super(name);
    }

    public ServerAction(String name, String command) {
        this(name, command, null);
    }

    public ServerAction(String name, Icon icon) {
        super(name, icon);
    }

    public ServerAction(String name, String command, Icon icon) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
    }

    public void setURL(String url) {
        this.putValue(URL, url);
        this.putValue(URL_CACHE, null);
    }

    public String getURL() {
        return (String)this.getValue(URL);
    }

    private Map getParams() {
        return (Map)this.getValue(PARAMS);
    }

    private void setParams(Map params) {
        this.putValue(PARAMS, params);
    }

    public void addParam(String name, String value) {
        HashMap<String, String> params = this.getParams();
        if (params == null) {
            params = new HashMap<String, String>();
            this.setParams(params);
        }
        params.put(name, value);
    }

    public String getParamValue(String name) {
        Map params = this.getParams();
        return params == null ? null : (String)params.get(name);
    }

    public Set getParamNames() {
        Map params = this.getParams();
        return params == null ? null : params.keySet();
    }

    private Map getHeaders() {
        return (Map)this.getValue(HEADERS);
    }

    private void setHeaders(Map headers) {
        this.putValue(HEADERS, headers);
    }

    public void addHeader(String name, String value) {
        HashMap<String, String> map = this.getHeaders();
        if (map != null) {
            map = new HashMap<String, String>();
            this.setHeaders(map);
        }
        map.put(name, value);
    }

    public String getHeaderValue(String name) {
        Map headers = this.getHeaders();
        return headers == null ? null : (String)headers.get(name);
    }

    public Set getHeaderNames() {
        Map headers = this.getHeaders();
        return headers == null ? null : headers.keySet();
    }

    public void actionPerformed(ActionEvent evt) {
        URL execURL = (URL)this.getValue(URL_CACHE);
        if (execURL == null && !"".equals(this.getURL())) {
            try {
                String url = this.getURL();
                execURL = url.startsWith("http") ? new URL(url) : Application.getURL(url, this);
                if (execURL == null) {
                    return;
                }
                this.putValue(URL_CACHE, execURL);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        try {
            URLConnection uc = execURL.openConnection();
            Set headerNames = this.getHeaderNames();
            if (headerNames != null && !headerNames.isEmpty()) {
                Iterator iter = headerNames.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    uc.setRequestProperty(name, this.getHeaderValue(name));
                }
            }
            uc.setUseCaches(false);
            uc.setDoOutput(true);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
            PrintWriter out = new PrintWriter(byteStream, true);
            out.print(this.getPostData());
            out.flush();
            String length = String.valueOf(byteStream.size());
            uc.setRequestProperty("Content-length", length);
            byteStream.writeTo(uc.getOutputStream());
            BufferedReader buf = null;
            if (uc instanceof HttpURLConnection) {
                String line;
                HttpURLConnection huc = (HttpURLConnection)uc;
                int code = huc.getResponseCode();
                String message = huc.getResponseMessage();
                buf = code < 400 ? new BufferedReader(new InputStreamReader(uc.getInputStream())) : new BufferedReader(new InputStreamReader(huc.getErrorStream()));
                StringBuffer buffer = new StringBuffer();
                while ((line = buf.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                if (Debug.debug) {
                    System.out.println(buffer.toString());
                }
            }
        }
        catch (UnknownHostException uhe) {
            Debug.printException("UnknownHostException detected. Could it be a proxy issue?\n" + uhe.getMessage(), uhe);
        }
        catch (AccessControlException aex) {
            Debug.printException("AccessControlException detected\n" + aex.getMessage(), aex);
        }
        catch (IOException ex) {
            Debug.printException("IOException detected\n" + ex.getMessage(), ex);
        }
    }

    private String getPostData() {
        StringBuffer postData = new StringBuffer();
        Set paramNames = this.getParamNames();
        if (paramNames != null && !paramNames.isEmpty()) {
            Iterator iter = paramNames.iterator();
            try {
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    postData.append('&').append(name).append('=');
                    postData.append(this.getParamValue(name));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            postData.setCharAt(0, '?');
        }
        if (Debug.debug) {
            System.out.println("ServerAction: POST data: " + postData.toString());
        }
        return postData.toString();
    }

    private StringBuffer getDataBuffer() throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer("content=");
        return buffer;
    }

    private String createMessage(int code, String msg) {
        StringBuffer buffer = new StringBuffer("The action \"");
        buffer.append(this.getValue("Name"));
        if (code < 400) {
            buffer.append("\" has succeeded ");
        } else {
            buffer.append("\" has failed\nPlease check the Java console for more details.\n");
        }
        buffer.append("\nServer response:\nCode: ");
        buffer.append(code);
        buffer.append(" Message: ");
        buffer.append(msg);
        return buffer.toString();
    }
}

