/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.jdesktop.swing.Application;
import org.jdesktop.swing.actions.AbstractActionExt;
import org.jdesktop.swing.actions.ActionManager;

public class CompositeAction
extends AbstractActionExt {
    private static final String LIST_IDS = "action-list-ids";

    public CompositeAction() {
        this("CompositeAction");
    }

    public CompositeAction(String name) {
        super(name);
    }

    public CompositeAction(String name, String command) {
        super(name, command);
    }

    public CompositeAction(String name, Icon icon) {
        super(name, icon);
    }

    public CompositeAction(String name, String command, Icon icon) {
        super(name, command, icon);
    }

    public void addAction(String id) {
        ArrayList<String> list = (ArrayList<String>)this.getValue(LIST_IDS);
        if (list == null) {
            list = new ArrayList<String>();
            this.putValue(LIST_IDS, list);
        }
        list.add(id);
    }

    public List getActionIDs() {
        return (List)this.getValue(LIST_IDS);
    }

    public void actionPerformed(ActionEvent evt) {
        ActionManager manager = Application.getInstance().getActionManager();
        Iterator iter = this.getActionIDs().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Action action = manager.getAction(id);
            if (action == null) continue;
            action.actionPerformed(evt);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        ActionManager manager = Application.getInstance().getActionManager();
        Iterator iter = this.getActionIDs().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Action action = manager.getAction(id);
            if (action == null || !(action instanceof AbstractActionExt)) continue;
            ((AbstractActionExt)action).itemStateChanged(evt);
        }
    }
}

