/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.EventHandler;
import java.beans.Statement;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.jdesktop.swing.actions.AbstractActionExt;

public class BoundAction
extends AbstractActionExt {
    private EventListenerList listeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BoundAction() {
        this("BoundAction");
    }

    public BoundAction(String name) {
        super(name);
    }

    public BoundAction(String name, String command) {
        super(name, command);
    }

    public BoundAction(String name, Icon icon) {
        super(name, icon);
    }

    public BoundAction(String name, String command, Icon icon) {
        super(name, command, icon);
    }

    public void setCallback(String callback) {
        String[] elems = callback.split("#", 2);
        if (elems.length == 2) {
            try {
                Class<?> clz = Class.forName(elems[0]);
                Object obj = clz.newInstance();
                this.registerCallback(obj, elems[1]);
            }
            catch (Exception ex) {
                System.out.println("ERROR: setCallback(" + callback + ") - " + ex.getMessage());
            }
        }
    }

    public void registerCallback(Object handler, String method) {
        if (this.isStateAction()) {
            this.addItemListener(new BooleanInvocationHandler(handler, method));
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.addActionListener((ActionListener)EventHandler.create(clazz, handler, method));
        }
    }

    private void addListener(Class clz, EventListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(clz, listener);
    }

    private void removeListener(Class clz, EventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(clz, listener);
        }
    }

    private EventListener[] getListeners(Class clz) {
        if (this.listeners == null) {
            return null;
        }
        return this.listeners.getListeners(clz);
    }

    public void addActionListener(ActionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(clazz, listener);
    }

    public void removeActionListener(ActionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeListener(clazz, listener);
    }

    public ActionListener[] getActionListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ActionListener[])this.getListeners(clazz);
    }

    public void addItemListener(ItemListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(clazz, listener);
    }

    public void removeItemListener(ItemListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeListener(clazz, listener);
    }

    public ItemListener[] getItemListeners() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ItemListener[])this.getListeners(clazz);
    }

    public void actionPerformed(ActionEvent evt) {
        ActionListener[] alist = this.getActionListeners();
        if (alist != null) {
            int i = 0;
            while (i < alist.length) {
                alist[i].actionPerformed(evt);
                ++i;
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        boolean newValue;
        boolean oldValue = this.isSelected();
        if (oldValue != (newValue = evt.getStateChange() == 1)) {
            this.setSelected(newValue);
            ItemListener[] ilist = this.getItemListeners();
            if (ilist != null) {
                int i = 0;
                while (i < ilist.length) {
                    ilist[i].itemStateChanged(evt);
                    ++i;
                }
            }
        }
    }

    private class BooleanInvocationHandler
    implements ItemListener {
        private Statement falseStatement;
        private Statement trueStatement;

        public BooleanInvocationHandler(Object target, String methodName) {
            this.falseStatement = new Statement(target, methodName, new Object[]{Boolean.FALSE});
            this.trueStatement = new Statement(target, methodName, new Object[]{Boolean.TRUE});
        }

        public void itemStateChanged(ItemEvent evt) {
            Statement statement = evt.getStateChange() == 2 ? this.falseStatement : this.trueStatement;
            try {
                statement.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

