/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swing.decorator.PatternFilter;
import org.jdesktop.swing.decorator.PatternHighlighter;

public class JXSearchPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private final JLabel fieldName = new JLabel();
    private final JCheckBox matchCase = new JCheckBox();
    private final JComboBox searchCriteria = new JComboBox();
    private final JButton searchButton = new JButton();
    private final JTextField searchField = new JTextField();
    private final JComponent[] colleagues = new JComponent[]{this.matchCase, this.searchCriteria, this.searchButton, this.searchField};
    private PatternFilter patternFilter = null;
    private PatternHighlighter patternHighlighter = null;
    private JComponent targetComponent = null;

    public JXSearchPanel() {
        this.searchButton.setText("Search");
        this.matchCase.setText("Match Case");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"begins with", "contains", "ends with", "equals"});
        this.searchCriteria.setModel(model);
        this.searchField.setPreferredSize(new Dimension(80, 20));
        this.add(this.fieldName);
        this.add(this.searchCriteria);
        this.add(this.searchField);
        this.add(this.matchCase);
        this.addActionListener();
        this.addEditListener();
    }

    public int getMatchFlags() {
        return this.matchCase.isSelected() ? 0 : 2;
    }

    public Pattern getPattern() {
        String patternString;
        String searchString = this.searchField.getText();
        if (searchString.length() == 0) {
            return Pattern.compile(".*", this.getMatchFlags());
        }
        int criteria = this.searchCriteria.getSelectedIndex();
        switch (criteria) {
            case 0: {
                patternString = new String(String.valueOf(searchString) + ".*");
                break;
            }
            case 1: {
                patternString = new String(".*" + searchString + ".*");
                break;
            }
            case 2: {
                patternString = new String(".*" + searchString);
                break;
            }
            default: {
                patternString = searchString;
            }
        }
        return Pattern.compile(patternString, this.getMatchFlags());
    }

    private void addActionListener() {
        this.matchCase.addActionListener(this);
        this.searchButton.addActionListener(this);
        this.searchField.addActionListener(this);
        this.searchCriteria.addActionListener(this);
    }

    private void removeActionListener() {
        this.matchCase.removeActionListener(this);
        this.searchButton.removeActionListener(this);
        this.searchField.removeActionListener(this);
        this.searchCriteria.removeActionListener(this);
    }

    private void addEditListener() {
        this.searchField.getDocument().addDocumentListener(this);
    }

    private void removeEditListener() {
        this.searchField.getDocument().removeDocumentListener(this);
    }

    public void setPatternFilter(PatternFilter filter) {
        this.patternFilter = filter;
        if (filter == null) {
            this.fieldName.setText("Field");
        } else {
            this.fieldName.setText(filter.getColumnName());
        }
    }

    public PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public void setPatternHighlighter(PatternHighlighter highlighter) {
        this.patternHighlighter = highlighter;
        if (this.fieldName.getText().length() == 0) {
            this.fieldName.setText("Field");
        }
    }

    public PatternHighlighter getPatternHighlighter() {
        return this.patternHighlighter;
    }

    public void setTargetComponent(JComponent target) {
        this.targetComponent = target;
    }

    public JComponent getTargetComponent() {
        return this.targetComponent;
    }

    public void setFieldName(String name) {
        this.fieldName.setText(name);
    }

    public String getFieldName() {
        return this.fieldName.getText();
    }

    public void changedUpdate(DocumentEvent ev) {
        this.refresh();
    }

    public void insertUpdate(DocumentEvent ev) {
        this.refresh();
    }

    public void removeUpdate(DocumentEvent ev) {
        this.refresh();
    }

    public void actionPerformed(ActionEvent ev) {
        this.refresh();
    }

    protected void refresh() {
        PatternHighlighter highlighter;
        Pattern pattern = this.getPattern();
        PatternFilter filter = this.getPatternFilter();
        if (filter != null) {
            filter.setPattern(pattern);
        }
        if ((highlighter = this.getPatternHighlighter()) != null) {
            JComponent target;
            highlighter.setPattern(pattern);
            if (filter == null && (target = this.getTargetComponent()) != null) {
                target.repaint();
            }
        }
    }
}

