/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.swing.Searchable;

public class JXFindDialog
extends JDialog {
    private Searchable searchable;
    private JTextField findText;
    private JCheckBox matchCheck;
    private JCheckBox wrapCheck;
    private JCheckBox backCheck;
    private Pattern pattern;
    private Matcher matcher;
    private boolean DEBUG = true;
    private int lastIndex = -1;

    public JXFindDialog(Searchable searchable) {
        super((Frame)SwingUtilities.getWindowAncestor((Component)((Object)searchable)), "Find in this component");
        this.searchable = searchable;
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = gc.getBounds();
        int x = bounds.x + bounds.width / 3;
        int y = bounds.y + bounds.height / 3;
        this.setLocation(x, y);
        this.initUI();
        this.pack();
    }

    public void setDebug(boolean debug) {
        this.DEBUG = debug;
    }

    private void initUI() {
        this.getContentPane().add((Component)this.createFieldPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
    }

    private JComponent createFieldPanel() {
        JLabel label = new JLabel("Find Text: ");
        label.setDisplayedMnemonicIndex(2);
        label.setLabelFor(this.findText);
        this.findText = new JTextField();
        this.matchCheck = new JCheckBox(new MatchAction());
        this.wrapCheck = new JCheckBox(new WrapAction());
        this.backCheck = new JCheckBox(new BackwardAction());
        Box lBox = Box.createVerticalBox();
        lBox.add(label);
        lBox.add(Box.createGlue());
        Box rBox = Box.createVerticalBox();
        rBox.add(this.findText);
        rBox.add(this.matchCheck);
        rBox.add(this.wrapCheck);
        rBox.add(this.backCheck);
        Box box = Box.createHorizontalBox();
        box.add(lBox);
        box.add(rBox);
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return box;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        FindAction findAction = new FindAction();
        CloseAction closeAction = new CloseAction();
        JButton findButton = new JButton(findAction);
        panel.add(findButton);
        panel.add(new JButton(closeAction));
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        String ENTER_ACTION_KEY = "ENTER_ACTION_KEY";
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(enterKey, ENTER_ACTION_KEY);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        this.getRootPane().setDefaultButton(findButton);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(ENTER_ACTION_KEY, findAction);
        actionMap.put(CANCEL_ACTION_KEY, closeAction);
        return panel;
    }

    public void doFind() {
        this.doFind(this.getBackwardsFlag());
    }

    public void doFind(boolean backwards) {
        Pattern pattern = this.getPattern();
        this.lastIndex = this.searchable.search(this.getPattern(), this.lastIndex, backwards);
        if (this.lastIndex == -1) {
            JOptionPane.showMessageDialog(this, "Value not found");
        }
    }

    public void doClose() {
        this.dispose();
    }

    public boolean getMatchFlag() {
        return this.matchCheck.isSelected();
    }

    public void setMatchFlag(boolean flag) {
        this.matchCheck.setSelected(flag);
    }

    public boolean getWrapFlag() {
        return this.wrapCheck.isSelected();
    }

    public void setWrapFlag(boolean flag) {
        this.wrapCheck.setSelected(flag);
    }

    public boolean getBackwardsFlag() {
        return this.backCheck.isSelected();
    }

    public void setBackwardsFlag(boolean flag) {
        this.backCheck.setSelected(flag);
    }

    private Pattern getPattern() {
        String searchString = this.findText.getText();
        if (searchString.length() == 0) {
            return null;
        }
        if (this.pattern == null || !this.pattern.pattern().equals(searchString)) {
            this.pattern = Pattern.compile(searchString, this.getMatchFlag() ? 0 : 2);
            this.lastIndex = -1;
        }
        return this.pattern;
    }

    private class FindAction
    extends AbstractAction {
        public FindAction() {
            super("Find");
        }

        public void actionPerformed(ActionEvent evt) {
            JXFindDialog.this.doFind();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent evt) {
            if (JXFindDialog.this.DEBUG) {
                System.err.println(this.getValue("Name"));
            }
            JXFindDialog.this.doClose();
        }
    }

    private abstract class CheckAction
    extends AbstractAction {
        public CheckAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if (JXFindDialog.this.DEBUG) {
                System.err.println(this.getValue("Name"));
            }
        }
    }

    private class MatchAction
    extends CheckAction {
        public MatchAction() {
            super("Match upper/lower case");
            this.putValue("MnemonicKey", new Integer(77));
        }
    }

    private class WrapAction
    extends CheckAction {
        public WrapAction() {
            super("Wrap around");
            this.putValue("MnemonicKey", new Integer(87));
        }
    }

    private class BackwardAction
    extends CheckAction {
        public BackwardAction() {
            super("Search Backwards");
            this.putValue("MnemonicKey", new Integer(66));
        }
    }
}

