/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.beans.Beans;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.jdesktop.swing.WebStartContext;
import org.jdesktop.swing.actions.ActionManager;
import org.jdesktop.swing.event.SelectionListener;
import org.jdesktop.swing.utils.SwingWorker;

public class Application {
    private static final int WINDOWS = 0;
    private static final int APPLETS = 1;
    private static Map appMap = new Hashtable();
    private static Map imageCache = new HashMap();
    private ActionMap actionMap;
    private ActionManager manager;
    private String title = "JDNC Application";
    private String versionString = "";
    private Image splashImage = null;
    private Image titleBarImage = null;
    private URL baseURL;
    private Vector[] toplevel = new Vector[2];
    private List selectionListeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Application getInstance() {
        return Application.getInstance("theone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application getInstance(Object key) {
        Application app = null;
        Map map = appMap;
        synchronized (map) {
            app = (Application)appMap.get(key);
            if (app == null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    app = (Application)Beans.instantiate(cl, "org.jdesktop.swing.Application");
                    appMap.put(key, app);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return app;
    }

    public static Application getApp(Component c) {
        Component p;
        Application app = null;
        Container parent = c instanceof Container ? (Container)c : c.getParent();
        while (parent != null) {
            if (parent instanceof Window) {
                app = Application.findApp(0, parent);
                break;
            }
            if (parent instanceof Applet) {
                app = Application.findApp(1, parent);
                break;
            }
            parent = parent.getParent();
        }
        if (app == null && (p = SwingUtilities.getRoot(c)) != null) {
            app = Application.getInstance(p);
            if (p instanceof Applet) {
                app.registerApplet((Applet)p);
            } else {
                app.registerWindow((Window)p);
            }
        }
        return app;
    }

    private static Application findApp(int type, Component c) {
        Application app = null;
        Iterator apps = appMap.values().iterator();
        while (app == null && apps.hasNext()) {
            Application a = (Application)apps.next();
            if (a.toplevel[type] == null || !a.toplevel[type].contains(c)) continue;
            app = a;
            break;
        }
        return app;
    }

    public ActionManager getActionManager() {
        if (this.manager == null) {
            this.manager = new ActionManager();
        }
        return this.manager;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public static URL getBaseURL(Object obj) {
        URL url = null;
        if (obj instanceof Component) {
            Application app;
            Container parent;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.JApplet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((parent = SwingUtilities.getAncestorOfClass(clazz, (Component)obj)) != null) {
                JApplet applet = (JApplet)parent;
                url = applet.getDocumentBase();
            } else {
                WebStartContext context = WebStartContext.getInstance();
                url = context.getDocumentBase();
            }
            if (url == null && (app = Application.getApp((Component)obj)) != null) {
                url = app.getBaseURL();
            }
        }
        if (url == null) {
            url = Application.getInstance().getBaseURL();
        }
        return url;
    }

    public static URL getURL(String value, Object obj) {
        URL base;
        URL url = Application.getURLResource(value, obj);
        if (url == null) {
            try {
                url = new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null && (base = Application.getBaseURL(obj)) != null) {
            try {
                url = new URL(base, value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL getURLResource(String value, Object obj) {
        return obj.getClass().getResource(value);
    }

    public static Image getImage(String name, Object obj) {
        Icon icon = Application.getIcon(name, obj);
        if (icon != null) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static Icon getIcon(String name, Object obj) {
        Icon icon = null;
        if (name == null || (icon = (Icon)imageCache.get(name)) != null) {
            return icon;
        }
        URL fileLoc = Application.getURL(name, obj);
        if (fileLoc != null && (icon = new ImageIcon(fileLoc)) != null) {
            imageCache.put(name, icon);
        }
        return icon;
    }

    public void showDocument(final URL url, final String target) {
        if (this.isRunningApplet()) {
            Iterator iter = this.getApplets();
            if (iter != null) {
                Applet applet = (Applet)iter.next();
                final AppletContext context = applet.getAppletContext();
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        context.showDocument(url, target);
                        return null;
                    }
                };
                worker.start();
            }
        } else if (this.isRunningWebStart()) {
            final WebStartContext context = WebStartContext.getInstance();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    context.showDocument(url, target);
                    return null;
                }
            };
            worker.start();
        } else {
            String[] command = null;
            String os = System.getProperty("os.name").toLowerCase();
            command = os.indexOf("os x") >= 0 ? new String[]{"open", url.toExternalForm()} : (os.indexOf("wind") >= 0 ? new String[]{"rundll32 url.dll,FileProtocolHandler", url.toExternalForm()} : new String[]{"mozilla", "-remote", "openurl(" + url.toExternalForm() + ")"});
            this.executeCommand(command);
        }
    }

    void executeCommand(final String[] command) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
        worker.start();
    }

    public void setSplashImage(Image splashImage) {
        this.splashImage = splashImage;
    }

    public Image getSplashImage() {
        return this.splashImage;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleBarImage(Image titleBarImage) {
        this.titleBarImage = titleBarImage;
    }

    public Image getTitleBarImage() {
        return this.titleBarImage;
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public boolean isStandAlone() {
        return this.getApplets() == null;
    }

    public boolean isRunningInSandbox() {
        boolean inSandbox = false;
        try {
            new File(".");
        }
        catch (SecurityException e) {
            inSandbox = true;
        }
        return inSandbox;
    }

    public boolean isRunningApplet() {
        return this.getApplets() != null;
    }

    public boolean isRunningWebStart() {
        try {
            Class<?> service = Class.forName("javax.jnlp.ServiceManager");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method lookup = service.getMethod("lookup", classArray);
            Object basic = lookup.invoke(null, "javax.jnlp.BasicService");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void registerWindow(Window window) {
        this.register(0, window);
    }

    public void unregisterWindow(Window window) {
        this.unregister(0, window);
    }

    public void registerApplet(Applet applet) {
        this.register(1, applet);
    }

    public void unregisterApplet(Applet applet) {
        this.unregister(1, applet);
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public Iterator getApplets() {
        return this.getToplevels(1);
    }

    public Iterator getWindows() {
        return this.getToplevels(0);
    }

    public void addSelectionListener(SelectionListener l) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList();
        }
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(l);
        }
    }

    public SelectionListener[] getSelectionListeners() {
        if (this.selectionListeners != null) {
            return this.selectionListeners.toArray(new SelectionListener[1]);
        }
        return new SelectionListener[0];
    }

    private void register(int type, Component c) {
        if (this.toplevel[type] == null) {
            this.toplevel[type] = new Vector();
        }
        this.toplevel[type].add(c);
    }

    private void unregister(int type, Component c) {
        if (this.toplevel[type] != null) {
            this.toplevel[type].remove(c);
        }
    }

    private Iterator getToplevels(int type) {
        if (this.toplevel[type] == null) {
            return null;
        }
        return this.toplevel[type].iterator();
    }
}

