/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.jdnc.ColumnPropertyHighlighter;
import org.jdesktop.jdnc.JNComponent;
import org.jdesktop.swing.JXTable;
import org.jdesktop.swing.JXTreeTable;
import org.jdesktop.swing.data.TabularDataModel;
import org.jdesktop.swing.decorator.FilterPipeline;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;
import org.jdesktop.swing.icon.ColumnControlIcon;
import org.jdesktop.swing.table.ColumnHeaderRenderer;
import org.jdesktop.swing.table.TableCellRenderers;
import org.jdesktop.swing.table.TableColumnExt;

public class JNTable
extends JNComponent {
    public int DEFAULT_ROW_HEIGHT = 22;
    public int DEFAULT_ROW_MARGIN = 1;
    public int DEFAULT_VISIBLE_ROW_COUNT = 20;
    public int DEFAULT_COLUMN_MARGIN = 0;
    private boolean hasColumnControl = false;
    private boolean rowHeaderLocked = false;
    private JTable rowHeaderTable = null;
    private TableColumn firstColumn = null;
    protected JScrollPane scrollPane;
    protected JXTable jxtable;
    private ColumnControlButton columnControlButton = null;
    private ColumnPropertyHighlighter highlighter;

    public JNTable() {
        this(new DefaultTableModel());
    }

    public JNTable(TableModel model) {
        this(new JXTable(model));
    }

    public JNTable(URL url) {
        this.setTable(new JXTable());
        TabularDataModel model = new TabularDataModel(url);
        this.setModel(model);
        try {
            model.startLoading();
        }
        catch (IOException ioe) {
            this.sendMessage(ioe.getMessage());
        }
        this.initUI();
    }

    protected JNTable(JTable jxtable) {
        this.setTable((JXTable)jxtable);
        this.setModel(jxtable.getModel());
        this.initUI();
    }

    private void initUI() {
        this.setRowHeight(this.DEFAULT_ROW_HEIGHT);
        this.setRowMargin(this.DEFAULT_ROW_MARGIN);
        this.scrollPane = new JScrollPane(this.jxtable);
        this.add(this.scrollPane);
    }

    protected void setTable(JXTable jxtable) {
        this.jxtable = jxtable;
        this.setComponent(jxtable);
    }

    public JXTable getTable() {
        return this.jxtable;
    }

    public void setModel(TableModel model) {
        TableModel oldModel = this.jxtable.getModel();
        if (!(this.jxtable instanceof JXTreeTable)) {
            this.jxtable.setModel(model);
            this.firePropertyChange("model", oldModel, model);
        }
        model.addTableModelListener(new TableModelAdapter());
    }

    public TableModel getModel() {
        return this.jxtable.getModel();
    }

    public void addColumn(TableColumnExt column) {
        this.jxtable.addColumn(column);
    }

    public void removeColumn(TableColumnExt column) {
        this.jxtable.removeColumn(column);
    }

    public TableColumnExt getColumn(String name) {
        return (TableColumnExt)this.jxtable.getColumn(name);
    }

    public TableColumnExt getColumn(int currentViewIndex) {
        return (TableColumnExt)this.jxtable.getColumnModel().getColumn(currentViewIndex);
    }

    public Color getOddRowBackground() {
        return this.highlighter != null ? this.highlighter.getOddRowBackground() : null;
    }

    public void setOddRowBackground(Color color) {
        this.initHighlighter();
        Color old = this.highlighter.getOddRowBackground();
        this.highlighter.setOddRowBackground(color);
        this.firePropertyChange("oddRowBackground", old, color);
    }

    public Color getEvenRowBackground() {
        return this.highlighter != null ? this.highlighter.getEvenRowBackground() : null;
    }

    public void setEvenRowBackground(Color color) {
        this.initHighlighter();
        Color old = this.highlighter.getEvenRowBackground();
        this.highlighter.setEvenRowBackground(color);
        this.firePropertyChange("evenRowBackground", old, color);
    }

    private void initHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new ColumnPropertyHighlighter();
            HighlighterPipeline pipeline = this.jxtable.getHighlighters();
            if (pipeline != null) {
                pipeline.addHighlighter(this.highlighter, true);
            } else {
                pipeline = new HighlighterPipeline(new Highlighter[]{this.highlighter});
                this.jxtable.setHighlighters(pipeline);
            }
        }
    }

    public boolean getHasColumnControl() {
        return this.hasColumnControl;
    }

    public void setHasColumnControl(boolean hasControl) {
        boolean old = this.hasColumnControl;
        if (hasControl) {
            if (this.columnControlButton == null) {
                this.columnControlButton = new ColumnControlButton(new ColumnControlIcon());
            }
            this.columnControlButton.bind(this.getTable());
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.columnControlButton);
        } else {
            try {
                this.scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hasColumnControl = hasControl;
        this.firePropertyChange("hasColumnControl", old, hasControl);
    }

    public boolean isRowHeaderLocked() {
        return this.rowHeaderLocked;
    }

    public void setRowHeaderLocked(boolean lockState) {
        if (this.rowHeaderLocked != lockState) {
            if (this.firstColumn == null) {
                this.firstColumn = this.initRowHeader();
            }
            if (lockState) {
                this.lockRowHeader();
            } else {
                this.unlockRowHeader();
            }
            this.rowHeaderLocked = lockState;
        }
    }

    protected TableColumn initRowHeader() {
        this.rowHeaderTable = new JXTable(this.jxtable.getModel());
        TableColumnModel tableColumnModel = this.jxtable.getColumnModel();
        TableColumn firstColumn = tableColumnModel.getColumn(0);
        this.rowHeaderTable.setAutoResizeMode(0);
        this.rowHeaderTable.getTableHeader().setReorderingAllowed(false);
        this.rowHeaderTable.getTableHeader().setResizingAllowed(false);
        this.rowHeaderTable.setPreferredScrollableViewportSize(new Dimension(firstColumn.getPreferredWidth() + this.rowHeaderTable.getColumnModel().getColumnMargin(), 0));
        TableColumnModel headerTableColumnModel = this.rowHeaderTable.getColumnModel();
        int i = headerTableColumnModel.getColumnCount() - 1;
        while (i > 0) {
            headerTableColumnModel.removeColumn(headerTableColumnModel.getColumn(i));
            --i;
        }
        return firstColumn;
    }

    protected void lockRowHeader() {
        TableColumnModel tableColumnModel = this.jxtable.getColumnModel();
        tableColumnModel.removeColumn(this.firstColumn);
        this.scrollPane.setRowHeaderView(this.rowHeaderTable);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.rowHeaderTable.getTableHeader());
        this.jxtable.revalidate();
    }

    protected void unlockRowHeader() {
        TableColumnModel tableColumnModel = this.jxtable.getColumnModel();
        tableColumnModel.addColumn(this.firstColumn);
        int numColumns = tableColumnModel.getColumnCount();
        tableColumnModel.moveColumn(numColumns - 1, 0);
        this.scrollPane.setRowHeaderView(null);
        this.jxtable.revalidate();
    }

    public int getRowHeight() {
        return this.jxtable.getRowHeight();
    }

    public void setRowHeight(int value) {
        int old = this.jxtable.getRowHeight();
        this.jxtable.setRowHeight(value);
        this.firePropertyChange("rowHeight", old, value);
    }

    public int getPreferredVisibleRowCount() {
        return this.jxtable.getVisibleRowCount();
    }

    public void setPreferredVisibleRowCount(int value) {
        int old = this.jxtable.getVisibleRowCount();
        this.jxtable.setVisibleRowCount(value);
        this.firePropertyChange("preferredVisibleRowCount", old, value);
    }

    public int getColumnMargin() {
        return this.jxtable.getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.jxtable.setColumnMargin(value);
    }

    public int getRowMargin() {
        return this.jxtable.getRowMargin();
    }

    public void setRowMargin(int value) {
        this.jxtable.setRowMargin(value);
    }

    public int getSelectionMode() {
        return this.jxtable.getSelectionMode();
    }

    public void setSelectionMode(int mode) {
        this.jxtable.setSelectionMode(mode);
    }

    public boolean getShowHorizontalLines() {
        return this.jxtable.getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean value) {
        this.jxtable.setShowHorizontalLines(value);
    }

    public boolean getShowVerticalLines() {
        return this.jxtable.getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean value) {
        this.jxtable.setShowVerticalLines(value);
    }

    public FilterPipeline getFilters() {
        return this.jxtable.getFilters();
    }

    public void setFilters(FilterPipeline pipeline) {
        this.jxtable.setFilters(pipeline);
    }

    public HighlighterPipeline getHighlighters() {
        return this.jxtable.getHighlighters();
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        this.jxtable.setHighlighters(pipeline);
    }

    public void setBackground(Color color) {
        if (this.jxtable != null) {
            this.jxtable.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        if (this.jxtable != null) {
            this.jxtable.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setFont(Font font) {
        if (this.jxtable != null) {
            this.jxtable.setFont(font);
        }
        super.setFont(font);
    }

    public void setGridColor(Color color) {
        this.jxtable.setGridColor(color);
    }

    public void setHeaderBackground(Color headerBackground) {
        JTableHeader header = this.jxtable.getTableHeader();
        if (header != null) {
            header.setBackground(headerBackground);
        }
    }

    public Color getHeaderBackground() {
        JTableHeader header = this.jxtable.getTableHeader();
        if (header != null) {
            return header.getBackground();
        }
        return null;
    }

    public void setHeaderForeground(Color headerForeground) {
        JTableHeader header = this.getTable().getTableHeader();
        if (header != null) {
            header.setForeground(headerForeground);
        }
    }

    public Color getHeaderForeground() {
        JTableHeader header = this.getTable().getTableHeader();
        if (header != null) {
            return header.getForeground();
        }
        return null;
    }

    public void setHeaderFont(Font headerFont) {
        JTableHeader header = this.getTable().getTableHeader();
        if (header != null) {
            header.setFont(headerFont);
        }
    }

    public Font getHeaderFont() {
        JTableHeader header = this.getTable().getTableHeader();
        if (header != null) {
            return header.getFont();
        }
        return null;
    }

    private ColumnHeaderRenderer getColumnHeaderRenderer() {
        TableCellRenderer hr;
        JTableHeader header = this.getTable().getTableHeader();
        if (header != null && (hr = header.getDefaultRenderer()) instanceof ColumnHeaderRenderer) {
            return (ColumnHeaderRenderer)hr;
        }
        return null;
    }

    public void setHeaderSortUpIcon(Icon upIcon) {
        ColumnHeaderRenderer headerRenderer = this.getColumnHeaderRenderer();
        if (headerRenderer != null) {
            headerRenderer.setUpIcon(upIcon);
        }
    }

    public Icon getHeaderSortUpIcon() {
        ColumnHeaderRenderer headerRenderer = this.getColumnHeaderRenderer();
        if (headerRenderer != null) {
            return headerRenderer.getUpIcon();
        }
        return null;
    }

    public void setHeaderSortDownIcon(Icon downIcon) {
        ColumnHeaderRenderer headerRenderer = this.getColumnHeaderRenderer();
        if (headerRenderer != null) {
            headerRenderer.setDownIcon(downIcon);
        }
    }

    public Icon getHeaderSortDownIcon() {
        ColumnHeaderRenderer headerRenderer = this.getColumnHeaderRenderer();
        if (headerRenderer != null) {
            return headerRenderer.getDownIcon();
        }
        return null;
    }

    public Class getColumnClass(String columnName) {
        return this.jxtable.getColumnClass(this.jxtable.getColumnModel().getColumnIndex(columnName));
    }

    public void setColumnBackground(String columnName, Color background) {
        this.initHighlighter();
        this.highlighter.setColumnBackground(columnName, background);
    }

    public Color getColumnBackground(String columnName) {
        return this.highlighter != null ? this.highlighter.getColumnBackground(columnName) : null;
    }

    public void setColumnForeground(String columnName, Color foreground) {
        this.initHighlighter();
        this.highlighter.setColumnForeground(columnName, foreground);
    }

    public Color getColumnForeground(String columnName) {
        return this.highlighter != null ? this.highlighter.getColumnForeground(columnName) : null;
    }

    public void setColumnFont(String columnName, Font font) {
        this.initHighlighter();
        this.highlighter.setColumnFont(columnName, font);
    }

    public Font getColumnFont(String columnName) {
        return this.highlighter != null ? this.highlighter.getColumnFont(columnName) : null;
    }

    public void setColumnHorizontalAlignment(String columnName, int alignment) {
        TableColumnExt column = this.getColumn(columnName);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer == null) {
            renderer = TableCellRenderers.getNewDefaultRenderer(this.getColumnClass(columnName));
            column.setCellRenderer(renderer);
            if (renderer instanceof DefaultTableCellRenderer) {
                column.putClientProperty("saveAlignment", new Integer(((DefaultTableCellRenderer)renderer).getHorizontalAlignment()));
            }
        }
        column.putClientProperty("alignment", new Integer(alignment));
        if (renderer != null && renderer instanceof DefaultTableCellRenderer) {
            if (alignment != -1) {
                ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(alignment);
            } else {
                Integer restoreAlignment = (Integer)column.getClientProperty("saveAlignment");
                if (restoreAlignment != null) {
                    ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(restoreAlignment);
                }
            }
        }
    }

    public int getColumnHorizontalAlignment(String columnName) {
        TableColumnExt column = this.getColumn(columnName);
        Integer alignment = (Integer)column.getClientProperty("alignment");
        return alignment != null ? alignment : -1;
    }

    public void setColumnPrototypeValue(String columnName, Object prototype) {
        TableColumnExt column = this.getColumn(columnName);
        column.setPrototypeValue(prototype);
    }

    public Object getColumnPrototypeValue(String columnName) {
        TableColumnExt column = this.getColumn(columnName);
        return column.getPrototypeValue();
    }

    public boolean print() throws PrinterException {
        boolean printed = this.getTable().print();
        this.sendMessage("Print " + (printed ? "complete." : "cancelled."));
        return printed;
    }

    private void setRowColumnStatus() {
        TableColumnModel columnModel = this.jxtable.getColumnModel();
        TableModel model = this.jxtable.getModel();
        if (this.support != null) {
            this.support.fireMessage(String.valueOf(model.getRowCount()) + " rows, " + columnModel.getColumnCount() + " columns");
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "; " + this.getTable().toString();
    }

    private class TableModelAdapter
    implements TableModelListener {
        private TableModelAdapter() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1 && JNTable.this.columnControlButton != null) {
                JNTable.this.columnControlButton.bind(JNTable.this.getTable());
            }
            JNTable.this.setRowColumnStatus();
        }
    }

    private static class ColumnControlButton
    extends JButton {
        public static final String TITLE = "x";
        private int selectionCount = 0;
        private JTable table;
        private TableColumnModel columnModelCopy;
        private JPopupMenu popupMenu = null;
        private AbstractAction columnVisibilityAction = new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)ev.getSource();
                TableColumn column = (TableColumn)item.getClientProperty("column");
                if (item.isSelected()) {
                    ColumnControlButton.this.table.addColumn(column);
                    ColumnControlButton columnControlButton = ColumnControlButton.this;
                    columnControlButton.selectionCount = columnControlButton.selectionCount + 1;
                } else if (ColumnControlButton.this.selectionCount - 1 == 0) {
                    item.setSelected(true);
                } else {
                    ColumnControlButton.this.table.removeColumn(column);
                    ColumnControlButton columnControlButton = ColumnControlButton.this;
                    columnControlButton.selectionCount = columnControlButton.selectionCount - 1;
                }
            }
        };

        public ColumnControlButton() {
            super(TITLE);
            this.init();
        }

        public ColumnControlButton(Action action) {
            super(action);
            this.init();
        }

        public ColumnControlButton(Icon icon) {
            super(icon);
            this.init();
        }

        public ColumnControlButton(String title) {
            super(title);
            this.init();
        }

        public ColumnControlButton(String title, Icon icon) {
            super(title, icon);
            this.init();
        }

        private void init() {
            this.setFocusPainted(false);
            this.setMargin(new Insets(1, 2, 2, 1));
        }

        public void bind(JTable table) {
            this.table = table;
            this.copyColumnModel();
            this.createPopupMenu();
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent ev) {
                    if (ColumnControlButton.this.popupMenu.getComponentCount() > 0) {
                        ColumnControlButton button = ColumnControlButton.this;
                        Dimension buttonSize = button.getSize();
                        ColumnControlButton.this.popupMenu.show(button, buttonSize.width - ((ColumnControlButton)ColumnControlButton.this).popupMenu.getPreferredSize().width, buttonSize.height);
                    }
                }
            });
        }

        private void copyColumnModel() {
            TableColumnModel originalColumnModel = this.table.getColumnModel();
            this.columnModelCopy = new DefaultTableColumnModel();
            int count = originalColumnModel.getColumnCount();
            int i = 0;
            while (i < count) {
                this.columnModelCopy.addColumn(originalColumnModel.getColumn(i));
                ++i;
            }
        }

        protected void createPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            this.populatePopupMenu();
        }

        protected void populatePopupMenu() {
            int count;
            this.popupMenu.removeAll();
            this.selectionCount = count = this.columnModelCopy.getColumnCount();
            int i = 0;
            while (i < count) {
                TableColumn column = this.columnModelCopy.getColumn(i);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(column.getHeaderValue().toString(), true);
                item.putClientProperty("column", column);
                item.addActionListener(this.columnVisibilityAction);
                this.popupMenu.add(item);
                ++i;
            }
        }
    }
}

