/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.logger;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.log.format.PatternFormatter;

public class AvalonFormatter
extends PatternFormatter {
    public static final int DEFAULT_STACK_DEPTH = 8;
    public static final boolean DEFAULT_PRINT_CASCADING = true;
    private final int m_stackDepth;
    private final boolean m_printCascading;

    public AvalonFormatter(String pattern) {
        this(pattern, 8, true);
    }

    public AvalonFormatter(String pattern, int stackDepth, boolean printCascading) {
        super(pattern);
        this.m_stackDepth = stackDepth;
        this.m_printCascading = printCascading;
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (null == throwable) {
            return "";
        }
        return ExceptionUtil.printStackTrace((Throwable)throwable, (int)this.m_stackDepth, (boolean)this.m_printCascading);
    }

    static {
        DEFAULT_STACK_DEPTH = 8;
        DEFAULT_PRINT_CASCADING = true;
    }
}

