/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.bardsoftware.impl.eclipsito.DescriptorParser;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;

public class ModulesDirectoryProcessor {
    public static PluginDescriptor[] process(URI modulesdirUri, String descriptorPattern) {
        return ModulesDirectoryProcessor.processDescriptors(ModulesDirectoryProcessor.findModuleDescriptors(modulesdirUri, descriptorPattern));
    }

    protected static PluginDescriptor[] processDescriptors(URL[] moduleDescriptorUris) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        int i = 0;
        while (i < moduleDescriptorUris.length) {
            PluginDescriptor pluginDescriptor = DescriptorParser.parse(moduleDescriptorUris[i]);
            if (pluginDescriptor != null) {
                result.add(pluginDescriptor);
            }
            ++i;
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    protected static URL[] findModuleDescriptors(URI modulesdirUri, String descriptorPattern) {
        ArrayList<URL> result = new ArrayList<URL>();
        File[] directories = ModulesDirectoryProcessor.findSubdirectories(modulesdirUri);
        int i = 0;
        while (descriptorPattern != null && i < directories.length) {
            File descriptorFile = new File(directories[i], descriptorPattern);
            if (descriptorFile.exists() && descriptorFile.isFile()) {
                try {
                    result.add(descriptorFile.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }

    private static File[] findSubdirectories(URI rootUri) {
        Object[] result = new File(rootUri.getPath()).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (result == null) {
            result = new File[]{};
        }
        Arrays.sort(result);
        return result;
    }
}

