/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

class InternalReloader
implements Runnable {
    private String myThreadName = "InternalRealoader";
    private Thread myThread;
    private boolean isThreadDone = false;
    private int myCheckInterval = 2;
    private Bundle myBundle;

    InternalReloader(Bundle bundle) {
        this.myBundle = bundle;
    }

    public int getCheckInterval() {
        return this.myCheckInterval;
    }

    public void setCheckInterval(int checkInterval) {
        this.myCheckInterval = checkInterval;
    }

    public void run() {
        Boot.LOG.log(Level.FINE, "Background thread started");
        while (!this.isThreadDone) {
            this.sleepForCheckInterval();
            this.bundleModificationCheck();
        }
        Boot.LOG.log(Level.FINE, "Background thread stopped");
    }

    void threadStart() {
        if (this.myThread != null) {
            return;
        }
        Boot.LOG.log(Level.FINE, "Starting background thread");
        this.isThreadDone = false;
        this.myThreadName = "InternalReloader[" + this.myBundle.getSymbolicName() + "]";
        this.myThread = new Thread((Runnable)this, this.myThreadName);
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    void threadStop() {
        if (this.myThread == null) {
            return;
        }
        Boot.LOG.log(Level.FINE, "Stopping background thread");
        this.isThreadDone = true;
        this.myThread.interrupt();
        try {
            this.myThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myThread = null;
    }

    private void sleepForCheckInterval() {
        try {
            Thread.sleep((long)this.myCheckInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void bundleModificationCheck() {
        new Thread(){

            public void run() {
                try {
                    InternalReloader.this.myBundle.update();
                }
                catch (BundleException e) {
                    Boot.LOG.log(Level.WARNING, "Problems while reloading bundle: " + InternalReloader.this.myBundle.getSymbolicName());
                }
            }
        }.start();
    }
}

