/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class ExtensionPointImpl
implements IExtensionPoint {
    private final String myNamespace;
    private final String mySimpleName;
    private final String myLabel;
    private final String mySchemaReference;
    private final IExtension[] myExtensions;

    ExtensionPointImpl(PluginDescriptor.ExtensionPointDescriptor descriptor, IExtension[] extensions) {
        this.mySimpleName = descriptor.myRelativeName;
        this.myNamespace = descriptor.myNamespace;
        this.myLabel = descriptor.myLabel;
        this.mySchemaReference = descriptor.mySchemaReference;
        this.myExtensions = extensions;
    }

    public IExtension getExtension(String extensionId) {
        IExtension result = null;
        int i = 0;
        while (this.myExtensions != null && i < this.myExtensions.length) {
            if (this.myExtensions[i].getUniqueIdentifier().equals(extensionId)) {
                result = this.myExtensions[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public IExtension[] getExtensions() {
        return this.myExtensions;
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.myNamespace) + "." + this.mySimpleName;
    }

    public String getSimpleIdentifier() {
        return this.mySimpleName;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getSchemaReference() {
        return this.mySchemaReference;
    }

    public IConfigurationElement[] getConfigurationElements() {
        return new IConfigurationElement[0];
    }

    public String toString() {
        return "extension point: " + this.getUniqueIdentifier();
    }
}

