/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;

public final class RelationList
extends AbstractList
implements ToStringRequiresFile {
    private LinkedList m_list = new LinkedList();

    RelationList() {
    }

    RelationList(String data, MPXFile file) throws MPXException {
        int length = data.length();
        char sepchar = file.getDelimiter();
        if (length != 0) {
            int start = 0;
            int end = 0;
            while (end != length) {
                end = data.indexOf(sepchar, start);
                if (end == -1) {
                    end = length;
                }
                this.m_list.add(new Relation(data.substring(start, end).trim(), file));
                start = end + 1;
            }
        }
    }

    public String toString(MPXFile mpx) {
        char sepchar = mpx.getDelimiter();
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.m_list.iterator();
        while (iter.hasNext()) {
            if (sb.length() != 0) {
                sb.append(sepchar);
            }
            sb.append(((Relation)iter.next()).toString(mpx));
        }
        return sb.toString();
    }

    public Iterator iterator() {
        return this.m_list.iterator();
    }

    public boolean add(Object relation) {
        return this.m_list.add(relation);
    }

    public int size() {
        return this.m_list.size();
    }

    public Object get(int index) {
        return this.m_list.get(index);
    }
}

