/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.CodePage;
import com.tapsterrock.mpx.CurrencySymbolPosition;
import com.tapsterrock.mpx.DateFormat;
import com.tapsterrock.mpx.DateOrder;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDate;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXPercentage;
import com.tapsterrock.mpx.MPXRate;
import com.tapsterrock.mpx.MPXTime;
import com.tapsterrock.mpx.MPXUnits;
import com.tapsterrock.mpx.NumericBoolean;
import com.tapsterrock.mpx.ScheduleFrom;
import com.tapsterrock.mpx.TimeFormat;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.Tokenizer;
import java.io.IOException;
import java.util.LinkedList;

final class Record {
    private MPXFile m_parent;
    private String m_recordNumber;
    private String[] m_fields;
    public static final Record EMPTY_RECORD = new Record();

    private Record() {
        this.m_parent = null;
        this.m_fields = new String[0];
    }

    Record(MPXFile parent, Tokenizer tk) throws MPXException {
        try {
            this.m_parent = parent;
            LinkedList<String> list = new LinkedList<String>();
            while (tk.nextToken() == -3) {
                list.add(tk.getToken());
            }
            if (list.size() > 0) {
                this.m_recordNumber = (String)list.remove(0);
                this.m_fields = list.toArray(new String[list.size()]);
            }
        }
        catch (IOException ex) {
            throw new MPXException("Invalid record", ex);
        }
    }

    public String getRecordNumber() {
        return this.m_recordNumber;
    }

    public String getString(int field) {
        String result;
        if (field < this.m_fields.length) {
            result = this.m_fields[field];
            if (result != null) {
                result = result.replace('\u007f', '\n');
            }
        } else {
            result = null;
        }
        return result;
    }

    public Character getCharacter(int field) {
        Character result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? new Character(this.m_fields[field].charAt(0)) : null;
        return result;
    }

    public Float getFloat(int field) throws MPXException {
        Float result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? new Float(this.m_parent.getDecimalFormat().parse(this.m_fields[field]).floatValue()) : null;
        return result;
    }

    public Integer getInteger(int field) {
        Integer result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? Integer.valueOf(this.m_fields[field]) : null;
        return result;
    }

    public MPXDate getDateTime(int field) throws MPXException {
        MPXDate result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_parent.getDateTimeFormat().parse(this.m_fields[field]) : null;
        return result;
    }

    public MPXDate getDate(int field) throws MPXException {
        MPXDate result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_parent.getDateFormat().parse(this.m_fields[field]) : null;
        return result;
    }

    public MPXTime getTime(int field) throws MPXException {
        MPXTime result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_parent.getTimeFormat().parse(this.m_fields[field]) : null;
        return result;
    }

    public NumericBoolean getNumericBoolean(int field) {
        NumericBoolean result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? NumericBoolean.getInstance(this.m_fields[field]) : NumericBoolean.getInstance(false);
        return result;
    }

    public MPXRate getRate(int field) throws MPXException {
        MPXRate result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? new MPXRate(this.m_parent.getCurrencyFormat(), this.m_fields[field], this.m_parent.getLocale()) : null;
        return result;
    }

    public MPXCurrency getCurrency(int field) throws MPXException {
        MPXCurrency result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? MPXCurrency.getInstance(this.m_parent, this.m_fields[field]) : null;
        return result;
    }

    public MPXPercentage getPercentage(int field) throws MPXException {
        MPXPercentage result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? MPXPercentage.getInstance(this.m_fields[field], this.m_parent.getPercentageDecimalFormat()) : null;
        return result;
    }

    public MPXDuration getDuration(int field) throws MPXException {
        MPXDuration result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? MPXDuration.getInstance(this.m_fields[field], this.m_parent.getDurationDecimalFormat(), this.m_parent.getLocale()) : null;
        return result;
    }

    public MPXUnits getUnits(int field) throws MPXException {
        MPXUnits result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? new MPXUnits(this.m_fields[field], this.m_parent.getUnitsDecimalFormat()) : null;
        return result;
    }

    public TimeUnit getTimeUnit(int field) {
        TimeUnit result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? TimeUnit.getInstance(Integer.parseInt(this.m_fields[field])) : TimeUnit.DAYS;
        return result;
    }

    public TimeFormat getTimeFormat(int field) {
        TimeFormat result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? TimeFormat.getInstance(Integer.parseInt(this.m_fields[field])) : TimeFormat.TWELVE_HOUR;
        return result;
    }

    public ScheduleFrom getScheduleFrom(int field) {
        ScheduleFrom result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? ScheduleFrom.getInstance(Integer.parseInt(this.m_fields[field])) : ScheduleFrom.START;
        return result;
    }

    public DateOrder getDateOrder(int field) {
        DateOrder result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? DateOrder.getInstance(Integer.parseInt(this.m_fields[field])) : DateOrder.MDY;
        return result;
    }

    public CurrencySymbolPosition getCurrencySymbolPosition(int field) {
        CurrencySymbolPosition result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? CurrencySymbolPosition.getInstance(Integer.parseInt(this.m_fields[field])) : CurrencySymbolPosition.BEFORE;
        return result;
    }

    public DateFormat getDateFormat(int field) {
        DateFormat result = null;
        result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? DateFormat.getInstance(Integer.parseInt(this.m_fields[field])) : DateFormat.DD_MM_YY;
        return result;
    }

    public CodePage getCodePage(int field) {
        CodePage result = null;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            result = CodePage.getInstance(this.m_fields[field]);
        }
        return result;
    }

    public int getLength() {
        return this.m_fields.length;
    }
}

